/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.config.builder;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.configuration.builder.CoreConfigBuilder;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProviderRegistry;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.SAML1PolicyBuilder;
import org.eclipse.alf.security.sso.common.util.FileIOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvRPConfig;

public class FedSrvRPConfigBuilder {
    private static final Logger log = Logger.getLogger(FedSrvRPConfigBuilder.class);
    public static final String REQUEST_CONFIG_LN = "RequestConfig";
    public static final String RELYINGPARTY_LN = "RelyingParty";
    public static final String RELYINGPARTY_TYPE_LN = "Type";
    public static final String RELYINGPARTY_REALM_LN = "Realm";
    public static final String RELYINGPARTY_INSTANCE_LN = "Instance";
    public static final String CORE_CONFIG_LN = "CoreConfig";
    public static final String TOKEN_POLICY_LN = "TokenPolicy";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_FILE = "file";
    public static final String ATTR_TOKEN_TYPE = "tokenType";
    public static final String ATTR_NAME_DEFAULT = "default";
    protected String basePath;

    public FedSrvRPConfigBuilder() {
    }

    public FedSrvRPConfigBuilder(String basePath) {
        this.basePath = basePath;
    }

    public String getLocalName() {
        return REQUEST_CONFIG_LN;
    }

    public FedSrvRPConfig build(String filename) throws SSOException {
        FedSrvRPConfig retVal = null;
        InputStream is = FileIOHelper.loadResource((String)this.basePath, (String)filename);
        if (is != null) {
            retVal = this.build(is);
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                log.error((Object)"Error while closing input stream");
            }
        }
        return retVal;
    }

    public FedSrvRPConfig build(InputStream instream) throws SSOException {
        if (instream == null) {
            String errMsg = "Invalid input stream: null";
            log.error((Object)errMsg);
            throw new SSOException(errMsg);
        }
        StAXOMBuilder builder = null;
        try {
            builder = new StAXOMBuilder(instream);
        }
        catch (XMLStreamException e) {
            String errMsg = "Error obtaining StAXOMBuilder while trying to build config file object";
            log.error((Object)errMsg, (Throwable)e);
            throw new SSOException(errMsg, (Throwable)e);
        }
        if (builder == null) {
            String errMsg = "Failed to get a an StAXOMBuilder object: null";
            log.error((Object)errMsg);
            throw new SSOException(errMsg);
        }
        OMElement el = builder.getDocumentElement();
        if (el == null) {
            String errMsg = "The OM builder returned empty document";
            log.error((Object)errMsg);
            throw new SSOException(errMsg);
        }
        return this.build(el);
    }

    public FedSrvRPConfig build(OMElement element) throws SSOException {
        return this.build(element, null);
    }

    public FedSrvRPConfig build(OMElement element, FedSrvRPConfig base) throws SSOException {
        CoreConfigBuilder builder;
        CoreConfig coreConfig;
        if (element == null) {
            log.warn((Object)"FedSrvRPConfigBuilder.build(null) called");
            return null;
        }
        OMElement el = null;
        el = element.getLocalName().equals(this.getLocalName()) ? element : element.getFirstChildWithName(new QName(this.getLocalName()));
        if (el == null) {
            log.error((Object)"FedSrvRPConfigBuilder: service config element cannot be found");
            return null;
        }
        FedSrvRPConfig rpConfig = null;
        rpConfig = base != null ? base : new FedSrvRPConfig();
        OMElement rpuriEl = el.getFirstChildWithName(new QName(RELYINGPARTY_LN));
        if (rpuriEl != null) {
            String rpType = null;
            OMElement rpTypeEl = rpuriEl.getFirstChildWithName(new QName(RELYINGPARTY_TYPE_LN));
            if (rpTypeEl != null) {
                rpType = rpTypeEl.getText();
            }
            if (StringHelper.isBlank(rpType)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"<Type> element is missing. Assuming \"anonymous\"");
                }
                rpType = "anonymous";
            }
            String rpRealm = null;
            OMElement rpRealmEl = rpuriEl.getFirstChildWithName(new QName(RELYINGPARTY_REALM_LN));
            if (rpRealmEl != null) {
                rpRealm = rpRealmEl.getText();
            }
            if (StringHelper.isBlank(rpRealm)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"<Realm> element is missing. Assuming \"anonymous\"");
                }
                rpRealm = "anonymous";
            }
            String rpInstance = null;
            OMElement rpInstanceEl = rpuriEl.getFirstChildWithName(new QName(RELYINGPARTY_INSTANCE_LN));
            if (rpInstanceEl != null) {
                rpInstance = rpInstanceEl.getText();
            }
            if (StringHelper.isBlank(rpInstance)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"<Instance> element is missing. Assuming \"anonymous\"");
                }
                rpInstance = "anonymous";
            }
            RPURI rpuri = null;
            try {
                rpuri = new RPURI(rpType, rpRealm, rpInstance);
            }
            catch (SSOException e) {
                log.error((Object)("<RelyingParty> element contains invalid data and cannot be used as relying party identification URI: rpType=\"" + rpType + "\", " + "rpRealm=\"" + rpRealm + "\", " + "rpInstance=\"" + rpInstance + "\""));
                return null;
            }
            rpConfig.setRpuri(rpuri);
            if (log.isDebugEnabled()) {
                log.debug((Object)("<RelyingParty> element parsed: " + rpuri.toString()));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"<RelyingParty> element is missing");
            }
            return null;
        }
        OMElement configEl = el.getFirstChildWithName(new QName(CORE_CONFIG_LN));
        String configFile = XMLHelper.getAttribute((OMElement)configEl, (String)ATTR_FILE);
        if (configEl != null) {
            coreConfig = null;
            builder = new CoreConfigBuilder(this.basePath);
            if (StringHelper.isNotBlank((String)configFile)) {
                InputStream is = FileIOHelper.loadResource((String)this.basePath, (String)configFile);
                if (is != null) {
                    coreConfig = builder.build(is);
                    rpConfig.setCoreConfig(coreConfig);
                } else {
                    log.error((Object)("Failed to load CoreConfig from \"" + configFile + "\" (basePath=\"" + this.basePath + "\""));
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing input stream");
                    }
                }
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"<CoreConfig> element is missing");
            }
            return null;
        }
        coreConfig = builder.build(configEl, coreConfig);
        rpConfig.setCoreConfig(coreConfig);
        SAML1Policy tokenPolicy = null;
        SAML1PolicyBuilder samlPolicyBuilder = new SAML1PolicyBuilder();
        OMElement tokenPolicyEl = el.getFirstChildWithName(new QName(TOKEN_POLICY_LN));
        String tokenPolicyFile = XMLHelper.getAttribute((OMElement)tokenPolicyEl, (String)ATTR_FILE);
        String tokenPolicyTokenType = XMLHelper.getAttribute((OMElement)tokenPolicyEl, (String)ATTR_TOKEN_TYPE);
        if (StringHelper.isBlank((String)tokenPolicyTokenType)) {
            tokenPolicyTokenType = "*";
        }
        if (tokenPolicyEl != null) {
            if (StringHelper.isNotBlank((String)tokenPolicyFile)) {
                InputStream is = FileIOHelper.loadResource((String)this.basePath, (String)tokenPolicyFile);
                if (is != null) {
                    tokenPolicy = (SAML1Policy)samlPolicyBuilder.build(is);
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing input stream");
                    }
                    if (rpConfig.getCoreConfig() != null && rpConfig.getCoreConfig().getKeystoreProviderRegistry() != null) {
                        KeystoreProviderRegistry coreKeystoreProviderRegistry = rpConfig.getCoreConfig().getKeystoreProviderRegistry();
                        KeystoreProviderRegistry tokenPolicyKeystoreProviderRegistry = tokenPolicy.getKeystoreProviderRegistry();
                        tokenPolicyKeystoreProviderRegistry.addOrReplaceKeystoreRegistry(coreKeystoreProviderRegistry);
                    }
                    rpConfig.setTokenPolicy(tokenPolicy);
                } else {
                    log.error((Object)("Failed to load TokenPolicy from \"" + tokenPolicyFile + "\" (basePath=\"" + this.basePath + "\""));
                }
            }
            tokenPolicy = (SAML1Policy)samlPolicyBuilder.build(tokenPolicyEl, (BasePolicy)rpConfig.getTokenPolicy());
            if (rpConfig.getCoreConfig() != null && rpConfig.getCoreConfig().getKeystoreProviderRegistry() != null) {
                KeystoreProviderRegistry coreKeystoreProviderRegistry = rpConfig.getCoreConfig().getKeystoreProviderRegistry();
                KeystoreProviderRegistry tokenPolicyKeystoreProviderRegistry = tokenPolicy.getKeystoreProviderRegistry();
                tokenPolicyKeystoreProviderRegistry.addOrReplaceKeystoreRegistry(coreKeystoreProviderRegistry);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"<TokenPolicy> element is missing");
            }
            return null;
        }
        rpConfig.setTokenPolicy(tokenPolicy);
        return rpConfig;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}

