/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.handler;

import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenFactory;
import org.eclipse.alf.security.sso.common.util.SOAPHelper;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedDataObjectFactory;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedDataValidator;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataClientImpl;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.RSTDeserializer;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.SecurityContext;
import org.eclipse.alf.security.sso.common.ws.message.trust.issue.RSTIssueRequest;
import org.eclipse.alf.security.sso.common.ws.model.WSAbstractFactory;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.UsernameToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.OnBehalfOf;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityToken;
import org.eclipse.alf.security.sso.server.federationserver.LogonContext;
import org.eclipse.alf.security.sso.server.federationserver.PageRedirector;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfig;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvRPConfig;
import org.eclipse.alf.security.sso.server.federationserver.handler.FedSvrHandlerException;
import org.eclipse.alf.security.sso.server.federationserver.secctx.SecCtxFilterToLogonAppIncoming;

public class FedSrvInitialRequestHandler {
    static final Logger log = Logger.getLogger(FedSrvInitialRequestHandler.class);
    private FedSrvRPConfig fedconf = FedSrvConfig.getInstance().getRPConfig("uri:org:eclipse:alf:sso:relyingparty:anonymous:anonymous:anonymous");
    private CoreConfig coreconf = this.fedconf.getCoreConfig();
    private PageRedirector redirector = new PageRedirector(this.fedconf);

    public LogonContext handle(HttpServletRequest req, HttpServletResponse resp, LogonContext logonContext) throws ServletException {
        WSFedData wsfData = null;
        try {
            wsfData = WSFedHelper.extractWSFDataFromRequest((HttpServletRequest)req);
            if (wsfData == null) {
                log.error((Object)"FedSrvInitialRequestHandler.LogonContext. Error creating wsfData object");
                this.redirector.redirectAppError(req, resp, "Error creating wsfData object");
                return null;
            }
            this.validateWSFData(req, resp, wsfData);
            if (WSFedHelper.isRequestDataRemoted((WSFedData)wsfData)) {
                this.retrieveRemoteData(req, resp, wsfData);
            }
            if (StringHelper.isBlank((String)wsfData.getWreq()) && StringHelper.isNotBlank((String)wsfData.getWtrealm())) {
                String rpuri = wsfData.getWtrealm();
                try {
                    new RPURI(rpuri);
                }
                catch (SSOException e) {
                    log.error((Object)("Invalid federation request: applies to uri does not conform to ALF SSO format: \"" + rpuri + "\""));
                    this.redirector.redirectAppError(req, resp, "Invalid federation request: applies to uri does not conform to ALF SSO format: \"" + rpuri + "\"");
                    throw new FedSvrHandlerException();
                }
                this.fedconf = FedSrvConfig.getInstance().getRPConfig(rpuri);
                if (this.fedconf == null) {
                    log.error((Object)("Failed to find matching configuration for relying party request: \"" + rpuri + "\""));
                    this.redirector.redirectAppError(req, resp, "Failed to find matching configuration for relying party request: \"" + rpuri + "\"");
                    throw new FedSvrHandlerException();
                }
                CoreConfig coreConfig = this.fedconf.getCoreConfig();
                long requestTokenTTL = coreConfig.getLongParameter("SecurityTokenTTL", 28800L);
                RSTIssueRequest issueRequest = new RSTIssueRequest();
                issueRequest.setAppliesTo(rpuri);
                issueRequest.setTtl(requestTokenTTL);
                wsfData.setWreq(issueRequest.toOM().toString());
            } else if (StringHelper.isBlank((String)wsfData.getWreq())) {
                log.error((Object)"FedSrvInitialRequestHandler.LogonContext. Missing request data: empty wreq");
                this.redirector.redirectAppError(req, resp, "Malformed WS-Federation request");
                throw new FedSvrHandlerException();
            }
            OMElement payloadElement = null;
            String payloadString = wsfData.getWreq();
            try {
                payloadElement = XMLHelper.toOM((String)payloadString);
            }
            catch (SSOException e) {
                log.error((Object)("FedSrvInitialRequestHandler.LogonContext. Error trying to build an OM element from wreq: [" + payloadString + "]"), (Throwable)e);
                this.redirector.redirectAppError(req, resp, "Invalid WS-Federation request data");
                return null;
            }
            if (SOAPHelper.isSOAPEnvelope((OMElement)payloadElement)) {
                payloadElement = this.extractRSTFromSOAP(req, resp, payloadString);
            }
            if (!SSOHelper.isRSTElement((OMElement)payloadElement)) {
                log.error((Object)("Missing RST in wreq: [" + payloadString + "]"));
                this.redirector.redirectAppError(req, resp, "Invalid WS-Federation request data");
                return null;
            }
            RequestSecurityToken rst = this.extractRequestSecurityTokenFromPayload(req, resp, payloadElement);
            if (rst.getCancelTarget() != null) {
                try {
                    SSOToken cancelTarget = SSOTokenFactory.createSSOToken((Object)rst.getCancelTarget().getSecurityToken().getNativeObject());
                    logonContext.setCancelTarget(cancelTarget);
                }
                catch (SSOException e) {}
            } else {
                UsernameToken rstUsernameToken = this.extractUsernameTokenFromRST(req, resp, rst, payloadElement);
                if (rstUsernameToken != null) {
                    boolean forceAuth = this.coreconf.getBooleanParameter("ForceLocalAuthentication", false);
                    if (forceAuth) {
                        rst.setOnBehalfOf(null);
                        logonContext.setPrincipalCredentialsAquired(false);
                    } else {
                        logonContext.setPrincipalUsername(rstUsernameToken.getUsername());
                        logonContext.setPrincipalCredentialsAquired(true);
                        logonContext.setAuthCredentialsInRST(true);
                    }
                } else {
                    Principal principal = req.getUserPrincipal();
                    if (principal != null) {
                        boolean usePrincipal = this.coreconf.getBooleanParameter("UsePrincipalUserIfPresent", false);
                        boolean isAllowedAuthnType = this.coreconf.isAllowedPreauthenticationType(req.getAuthType());
                        if (usePrincipal && isAllowedAuthnType) {
                            log.debug((Object)("Using principal user: " + principal.getName() + "/" + req.getAuthType()));
                            this.addPrincipalToRSTWithinOnBehalfOfElement(req, resp, principal.getName(), rst, payloadElement);
                            logonContext.setPrincipalUsername(principal.getName());
                            logonContext.setPrincipalPassword(null);
                            logonContext.setAuthCredentialsInRST(true);
                            logonContext.setPrincipalCredentialsAquired(true);
                        } else {
                            log.warn((Object)("FedSrvInitialRequestHandler.LogonContext. Principal user is found on the request but authentication type is not allowed:" + principal.getName() + "/" + req.getAuthType()));
                        }
                    }
                }
            }
            logonContext.setRSTObject(rst);
            logonContext.setRSTElement(rst.toOM());
            logonContext.setWSFedData(wsfData);
        }
        catch (FedSvrHandlerException e) {
            log.error((Object)"FedSvrHandler Exception", (Throwable)e);
            return null;
        }
        return logonContext;
    }

    protected void validateWSFData(HttpServletRequest req, HttpServletResponse resp, WSFedData wsfData) throws FedSvrHandlerException, ServletException {
        if (wsfData.isEmpty()) {
            log.error((Object)"HTTP requests is missing WS-Federation PRP parameters");
            this.redirector.redrectDirectFobidden(req, resp);
            throw new FedSvrHandlerException();
        }
        WSFedDataValidator wsfFedDataValidator = WSFedDataObjectFactory.createWSFedDataValidator();
        ExtendedResult wsfValidationResult = wsfFedDataValidator.validateRequest(wsfData);
        if (!wsfValidationResult.isSuccess()) {
            log.error((Object)("WS-Federation request profile validation failed: " + wsfValidationResult.getMessage()));
            this.redirector.redirectAppError(req, resp, wsfValidationResult.getMessage());
            throw new FedSvrHandlerException();
        }
    }

    protected void retrieveRemoteData(HttpServletRequest req, HttpServletResponse resp, WSFedData wsfData) throws FedSvrHandlerException, ServletException {
        try {
            RemoteDataClientImpl remoteContentClient = new RemoteDataClientImpl();
            String remoteContentURL = wsfData.getWreqptr();
            String remoteContent = remoteContentClient.getRemoteContent(remoteContentURL, null);
            log.debug((Object)("remoteContentURL = " + remoteContentURL + " remoteContent" + remoteContent));
            if (remoteContent == null || remoteContent.trim().length() == 0) {
                log.error((Object)"Empty remote content returned");
                this.redirector.redirectAppError(req, resp, "Unable to get remote request data from " + wsfData.getWreqptr());
                throw new FedSvrHandlerException();
            }
            wsfData.setWreq(remoteContent);
            wsfData.setWreqptr(null);
        }
        catch (SSOException e) {
            log.error((Object)"Retrieving remote data", (Throwable)e);
            this.redirector.redirectAppError(req, resp, "Error fetching remote request from " + wsfData.getWreqptr());
            throw new FedSvrHandlerException();
        }
    }

    protected OMElement extractRSTFromSOAP(HttpServletRequest req, HttpServletResponse resp, String payloadString) throws FedSvrHandlerException, ServletException {
        SOAPEnvelope payloadElement = null;
        try {
            payloadElement = SOAPHelper.buildSOAPElement((String)payloadString);
        }
        catch (SSOException e) {
            log.error((Object)("Error trying to build a SOAP element from wreq: [" + payloadString + "]"), (Throwable)e);
            this.redirector.redirectAppError(req, resp, "Invalid wreq: [" + payloadString + "]");
            throw new FedSvrHandlerException();
        }
        log.debug((Object)"Received SOAP message containing RST element");
        String axis2repo = this.coreconf.getParameter("axis2repo", "${APPROOT_DIR}/WEB-INF");
        String axis2xml = this.coreconf.getParameter("axis2xml", "${CONFIG_DIR}/axis2.xml");
        try {
            RSTDeserializer soapDeserializer = new RSTDeserializer(axis2repo, axis2xml);
            SecCtxFilterToLogonAppIncoming securityContext = new SecCtxFilterToLogonAppIncoming();
            soapDeserializer.setSecurityContext((SecurityContext)securityContext);
            payloadElement = soapDeserializer.receiveSOAPMessage(payloadElement.toString());
        }
        catch (SSOException e) {
            log.error((Object)"", (Throwable)e);
            this.redirector.redirectAppError(req, resp, "Error deserializing SOAP message:[" + payloadString + "]");
            throw new FedSvrHandlerException();
        }
        catch (AxisFault e) {
            log.error((Object)"Axis fault", (Throwable)e);
            this.redirector.redirectAppError(req, resp, "Error sending/receiving SOAP message locally:[" + payloadString + "]");
            throw new FedSvrHandlerException();
        }
        return payloadElement;
    }

    protected RequestSecurityToken extractRequestSecurityTokenFromPayload(HttpServletRequest req, HttpServletResponse resp, OMElement payloadElement) throws FedSvrHandlerException, ServletException {
        RequestSecurityToken rst = null;
        try {
            rst = WSTrustObjectBuilder.buildRequestSecurityToken((OMElement)payloadElement);
        }
        catch (SSOException e) {
            log.error((Object)("Error deserializing RST element: [" + payloadElement.toString() + "]"));
            this.redirector.redirectAppError(req, resp, "Error deserializing RST element from wreq: [" + payloadElement.toString() + "]");
            throw new FedSvrHandlerException();
        }
        return rst;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private UsernameToken extractUsernameTokenFromRST(HttpServletRequest req, HttpServletResponse resp, RequestSecurityToken rst, OMElement payloadElement) throws FedSvrHandlerException, ServletException {
        UsernameToken onBehalfOfUsernameToken = null;
        if (rst.getOnBehalfOf() == null) return onBehalfOfUsernameToken;
        if (rst.getOnBehalfOf().getSecurityToken() != null) {
            if (rst.getOnBehalfOf().getSecurityToken().getType().equals("UsernameToken")) {
                onBehalfOfUsernameToken = (UsernameToken)rst.getOnBehalfOf().getSecurityToken().getNativeObject();
                if (onBehalfOfUsernameToken.getUsername() != null && onBehalfOfUsernameToken.getUsername().trim().length() != 0) return onBehalfOfUsernameToken;
                String errMsg = "Unsuppored RST - incompatible profile - missing <Username>:[" + payloadElement.toString() + "]";
                log.error((Object)errMsg);
                this.redirector.redirectAppError(req, resp, errMsg);
                throw new FedSvrHandlerException();
            }
            String errMsg = "Unsuppored RST - incompatible profile - incompatible token:[" + payloadElement.toString() + "]";
            log.error((Object)errMsg);
            this.redirector.redirectAppError(req, resp, errMsg);
            throw new FedSvrHandlerException();
        }
        String errMsg = "Unsuppored RST - incompatible profile - missing <UsernameToken>:[" + payloadElement.toString() + "]";
        log.error((Object)errMsg);
        this.redirector.redirectAppError(req, resp, errMsg);
        throw new FedSvrHandlerException();
    }

    protected RequestSecurityToken addPrincipalToRSTWithinOnBehalfOfElement(HttpServletRequest req, HttpServletResponse resp, String principal, RequestSecurityToken rst, OMElement payloadElement) throws FedSvrHandlerException, ServletException {
        OnBehalfOf onBehalfOf = rst.getWSTrust().getObjectFactory().createOnBehalfOf();
        UsernameToken usernameToken = WSAbstractFactory.getWSSEObjectFactory().createUsernameToken();
        usernameToken.addId();
        usernameToken.addCreated();
        usernameToken.setUsername(principal);
        onBehalfOf.setSecurityToken((SecurityToken)usernameToken);
        rst.setOnBehalfOf(onBehalfOf);
        return rst;
    }
}

