/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.handler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityToken;
import org.eclipse.alf.security.sso.server.federationserver.FedSrvHelper;
import org.eclipse.alf.security.sso.server.federationserver.LogonContext;
import org.eclipse.alf.security.sso.server.federationserver.PageRedirector;
import org.eclipse.alf.security.sso.server.federationserver.ProcessingException;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfig;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvRPConfig;
import org.eclipse.alf.security.sso.server.federationserver.handler.FedSrvCancelRequestHandler;
import org.eclipse.alf.security.sso.server.federationserver.handler.FedSrvInitialRequestHandler;
import org.eclipse.alf.security.sso.server.federationserver.handler.RemoteDataRequestHandler;
import org.eclipse.alf.security.sso.server.federationserver.processor.IssueRequestProcessor;
import org.eclipse.alf.security.sso.server.federationserver.processor.RequestProcessorResult;

public class FedSrvRequestHandler {
    private static final Logger log = Logger.getLogger(FedSrvRequestHandler.class);

    public void processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        RemoteDataRequestHandler remoteDataRequestHandler;
        LogonContext logonContext = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering the main request handler");
        }
        if ((remoteDataRequestHandler = new RemoteDataRequestHandler()).isValidRemoteDataRequest(req)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Serving remote data request");
            }
            remoteDataRequestHandler.serveRequest(req, resp);
            return;
        }
        HttpSession httpSession = req.getSession();
        LogonContext logonContextFromSession = (LogonContext)httpSession.getAttribute("LogonContext");
        if (logonContextFromSession != null) {
            logonContext = logonContextFromSession;
            httpSession.removeAttribute("LogonContext");
        } else {
            logonContext = new LogonContext();
        }
        if (logonContextFromSession == null) {
            PageRedirector redirector;
            FedSrvRPConfig rpConfig;
            FedSrvInitialRequestHandler initialRequestHandler;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Handling ws-federation intial request");
            }
            if ((logonContext = (initialRequestHandler = new FedSrvInitialRequestHandler()).handle(req, resp, logonContext)) == null) {
                log.error((Object)"Error creating logon context");
                return;
            }
            FedSrvHelper.extractSSOTokenFromCookies(req, resp, logonContext);
            RequestSecurityToken rstObj = logonContext.getRSTObject();
            if (rstObj.getRequestType().getRequestType().equals(rstObj.getWSTrust().RequestTypes.getCancel())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Handling/Serving a RST/Cancel request");
                }
                FedSrvCancelRequestHandler cancelHandler = new FedSrvCancelRequestHandler();
                cancelHandler.handle(req, resp, logonContext, rstObj, logonContext.getRSTElement());
                return;
            }
            if (!rstObj.getRequestType().getRequestType().equals(rstObj.getWSTrust().RequestTypes.getIssue())) {
                rpConfig = FedSrvConfig.getInstance().getRPConfig(logonContext.getAppliesToURI());
                if (rpConfig == null) {
                    rpConfig = FedSrvConfig.getInstance().getRPConfig("uri:org:eclipse:alf:sso:relyingparty:anonymous:anonymous:anonymous");
                }
                redirector = new PageRedirector(rpConfig);
                redirector.redirectAppError(req, resp, "Invalid request type");
            }
            if (!logonContext.getPrincipalCredentialsAquired()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Not sufficcient credentials found on the request, redirecting to login page");
                }
                if ((rpConfig = FedSrvConfig.getInstance().getRPConfig(logonContext.getAppliesToURI())) == null) {
                    rpConfig = FedSrvConfig.getInstance().getRPConfig("uri:org:eclipse:alf:sso:relyingparty:anonymous:anonymous:anonymous");
                }
                redirector = new PageRedirector(rpConfig);
                redirector.redirectToLoginPage(req, resp, logonContext, null);
                return;
            }
        } else {
            String username = req.getParameter("username");
            String password = req.getParameter("password");
            if (StringHelper.isBlank((String)username)) {
                FedSrvRPConfig rpConfig;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Username from login page is empty, redirecting back to login page");
                }
                if ((rpConfig = FedSrvConfig.getInstance().getRPConfig(logonContext.getAppliesToURI())) == null) {
                    rpConfig = FedSrvConfig.getInstance().getRPConfig("uri:org:eclipse:alf:sso:relyingparty:anonymous:anonymous:anonymous");
                }
                PageRedirector redirector = new PageRedirector(rpConfig);
                redirector.redirectToLoginPage(req, resp, logonContext, "Username cannot be empty");
                return;
            }
            logonContext.setPrincipalUsername(username.trim());
            logonContext.setPrincipalPassword(password.trim());
            logonContext.setPrincipalCredentialsAquired(true);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Process RST/Issue request");
        }
        IssueRequestProcessor issueProcessor = new IssueRequestProcessor();
        FedSrvRPConfig rpConfig = FedSrvConfig.getInstance().getRPConfig(logonContext.getAppliesToURI());
        if (rpConfig == null) {
            rpConfig = FedSrvConfig.getInstance().getRPConfig("uri:org:eclipse:alf:sso:relyingparty:anonymous:anonymous:anonymous");
        }
        PageRedirector redirector = new PageRedirector(rpConfig);
        RequestProcessorResult result = null;
        try {
            result = issueProcessor.process(req, resp, logonContext);
        }
        catch (ProcessingException e) {
            log.error((Object)("Error processing issue request: " + e.getMessage()));
            redirector.redirectAppError(req, resp, "Error processing issue request: " + e.getLocalizedMessage());
            return;
        }
        if (!result.isSuccess()) {
            log.error((Object)("Error processing issue request: " + result.getMessage()));
            redirector.redirectAppError(req, resp, "Error processing issue request: " + result.getMessage());
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully issued a token. Redirecting back to the relying party");
        }
        redirector.redrectBack(req, resp, result.getWsfData());
    }
}

