/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.processor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProvider;
import org.eclipse.alf.security.sso.server.federationserver.LogonContext;
import org.eclipse.alf.security.sso.server.federationserver.ProcessingException;
import org.eclipse.alf.security.sso.server.federationserver.processor.RequestProcessorResult;

public abstract class AbstractRequestProcessor {
    public abstract RequestProcessorResult process(HttpServletRequest var1, HttpServletResponse var2, LogonContext var3) throws ProcessingException;

    protected void processJSSEEnablement(CoreConfig conf) {
        boolean acceptSelfSignedSSLCertificates = conf.getBooleanParameter("SSLAcceptSelfSignedCertificates", true);
        KeystoreProvider keystoreProvider = conf.getKeystoreProvider("default");
        if (acceptSelfSignedSSLCertificates && keystoreProvider != null && keystoreProvider != null) {
            System.setProperty("javax.net.ssl.keyStore", keystoreProvider.getKeystoreFile());
            System.setProperty("javax.net.ssl.keyStorePassword", keystoreProvider.getKeystorePassword());
            System.setProperty("javax.net.ssl.trustStore", keystoreProvider.getKeystoreFile());
            System.setProperty("javax.net.ssl.trustStorePassword", keystoreProvider.getKeystorePassword());
        } else {
            System.clearProperty("javax.net.ssl.keyStore");
            System.clearProperty("javax.net.ssl.keyStorePassword");
            System.clearProperty("javax.net.ssl.trustStore");
            System.clearProperty("javax.net.ssl.trustStorePassword");
        }
    }
}

