/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.processor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataStorage;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.RSTCallProxy;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.SecurityContext;
import org.eclipse.alf.security.sso.common.ws.message.trust.cancel.RSTCancelRequest;
import org.eclipse.alf.security.sso.common.ws.message.trust.cancel.RSTRCancelValidationResult;
import org.eclipse.alf.security.sso.common.ws.message.trust.cancel.RSTRCancelValidator;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityTokenResponse;
import org.eclipse.alf.security.sso.server.federationserver.FedSrvHelper;
import org.eclipse.alf.security.sso.server.federationserver.LogonContext;
import org.eclipse.alf.security.sso.server.federationserver.ProcessingException;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfig;
import org.eclipse.alf.security.sso.server.federationserver.processor.AbstractRequestProcessor;
import org.eclipse.alf.security.sso.server.federationserver.processor.RequestProcessorResult;
import org.eclipse.alf.security.sso.server.federationserver.secctx.SecCtxLogonAppToSTS;

public class CancelRequestProcessor
extends AbstractRequestProcessor {
    private static Logger log = Logger.getLogger(CancelRequestProcessor.class);
    private static CoreConfig coreconf = FedSrvConfig.getInstance().getRPConfig("uri:org:eclipse:alf:sso:relyingparty:anonymous:anonymous:anonymous").getCoreConfig();

    public RequestProcessorResult process(HttpServletRequest req, HttpServletResponse resp, LogonContext logonContext) throws ProcessingException {
        RequestProcessorResult retVal = new RequestProcessorResult();
        WSFedData wsf = logonContext.getWSFedData();
        RequestSecurityTokenResponse rstr = null;
        RSTCallProxy callProxy = FedSrvHelper.getCallProxy();
        if (callProxy == null) {
            retVal.setCode(2);
            retVal.setMessage("Failed to create SOAP call proxy");
            return retVal;
        }
        RSTCancelRequest request = new RSTCancelRequest();
        request.setEpr(coreconf.getParameter("SecurityTokenService"));
        request.setRawRST(logonContext.getRSTElement());
        super.processJSSEEnablement(coreconf);
        try {
            SecCtxLogonAppToSTS securityContext = new SecCtxLogonAppToSTS();
            request.setSecurityContext((SecurityContext)securityContext);
            rstr = logonContext.rstr;
        }
        catch (AxisFault e) {
            log.error((Object)"Axis fault caught while issuing a SOAP call", (Throwable)e);
            retVal.setCode(1);
            retVal.setMessage(e.getMessage());
            return retVal;
        }
        catch (SSOException e) {
            log.error((Object)"SSO exception while issuing a SOAP call to STS.", (Throwable)e);
            retVal.setCode(2);
            retVal.setMessage(e.getMessage());
            return retVal;
        }
        RSTRCancelValidator cancelResponseValidator = new RSTRCancelValidator();
        RSTRCancelValidationResult validationResult = cancelResponseValidator.validate(callProxy.getResponsePayload());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Validated Cancel RSTR:" + validationResult.getCode()));
        }
        if (!validationResult.isSuccess()) {
            log.error((Object)("RSTR validation failed with code:" + validationResult.getCode()));
            throw new ProcessingException("RSTR validation failed");
        }
        String wresult = rstr.toString();
        boolean forceRemoteData = coreconf.getBooleanParameter("ForceRemoteDataInWSFederation", false);
        if (forceRemoteData) {
            log.debug((Object)"Returning result via remote data pattern");
            wsf.setWresult(wresult);
            long remoteDataTTL = coreconf.getLongParameter("RemoteDataTTL", 60L);
            RemoteDataStorage rd = RemoteDataStorage.getInstance();
            String rdKey = rd.addData((Object)wsf.getWresult(), remoteDataTTL);
            String remoteDataURL = coreconf.getRemoteDataURL(req.getRequestURL().toString(), req.getServerPort());
            wsf = WSFedHelper.convertWresultToWresultptr((String)remoteDataURL, (String)rdKey, (WSFedData)wsf);
        } else {
            log.debug((Object)"Returning result directly in POST form");
            wresult = XMLHelper.escapeXMLString((String)wresult);
            wsf.setWresult(wresult);
        }
        retVal.setWsfData(wsf);
        return retVal;
    }
}

