/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.builder;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.URIMatcher;
import org.eclipse.alf.security.sso.common.http.configuration.URIMatcherHttpParamSet;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;

public class URIMatcherBuilder {
    private static final Logger log = Logger.getLogger(URIMatcherBuilder.class);
    public static final String URI_MATCHER_LN = "URIMatcher";
    public static final String ATTR_REQUEST_URI_LN = "requestURI";
    public static final String ATTR_COMPARER_LN = "comparer";
    public static final String HTTP_PARAM_SET_LN = "HttpParamSet";
    public static final String HTTP_PARAM_LN = "HttpParam";
    public static final String NAME_LN = "Name";
    public static final String VALUE_LN = "Value";
    public static final String ATTRVAL_MATCHER_TYPE_BASIC = "basic";
    public static final String ATTRVAL_MATCHER_TYPE_REGEX = "regex";

    public URIMatcherBuilder() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public URIMatcher build(OMElement element) throws SSOException {
        if (element == null) {
            return null;
        }
        if (!element.getLocalName().equals(URI_MATCHER_LN)) {
            return null;
        }
        String requestURI = XMLHelper.getAttribute(element, ATTR_REQUEST_URI_LN);
        String comparer = XMLHelper.getAttribute(element, ATTR_COMPARER_LN);
        URIMatcher retVal = StringHelper.isBlank(comparer) ? new URIMatcher(1) : (comparer.equals(ATTRVAL_MATCHER_TYPE_BASIC) ? new URIMatcher(1) : (comparer.equals(ATTRVAL_MATCHER_TYPE_REGEX) ? new URIMatcher(2) : new URIMatcher(1)));
        if (StringHelper.isBlank(requestURI)) {
            return null;
        }
        retVal.setRequestURI(requestURI);
        Iterator httpParamSetIt = element.getChildrenWithName(new QName(HTTP_PARAM_SET_LN));
        while (httpParamSetIt != null && httpParamSetIt.hasNext()) {
            OMElement httpParamSetEl = (OMElement)httpParamSetIt.next();
            URIMatcherHttpParamSet httpParamSet = new URIMatcherHttpParamSet();
            Iterator httpParamIt = httpParamSetEl.getChildrenWithName(new QName(HTTP_PARAM_LN));
            while (httpParamIt != null && httpParamIt.hasNext()) {
                String name;
                OMElement nameEl;
                String defaultValue;
                int matcherType;
                OMElement httpParamEl = (OMElement)httpParamIt.next();
                comparer = XMLHelper.getAttribute(httpParamEl, ATTR_COMPARER_LN);
                if (StringHelper.isBlank(comparer)) {
                    matcherType = 1;
                    defaultValue = "*";
                } else if (comparer.equals(ATTRVAL_MATCHER_TYPE_BASIC)) {
                    matcherType = 1;
                    defaultValue = "*";
                } else if (comparer.equals(ATTRVAL_MATCHER_TYPE_REGEX)) {
                    matcherType = 2;
                    defaultValue = ".*";
                } else {
                    matcherType = 1;
                    defaultValue = "*";
                }
                if ((nameEl = httpParamEl.getFirstChildWithName(new QName(NAME_LN))) == null || !StringHelper.isNotBlank(name = nameEl.getText())) continue;
                Iterator valueIt = httpParamEl.getChildrenWithName(new QName(NAME_LN));
                if (valueIt == null || !valueIt.hasNext()) {
                    httpParamSet.addMatchHttpParamSet(matcherType, name, "*");
                    break;
                }
                while (valueIt.hasNext()) {
                    OMElement valueEl = (OMElement)valueIt.next();
                    String value = valueEl.getText();
                    value = StringHelper.isBlank(value) ? "*" : valueEl.getText();
                    httpParamSet.addMatchHttpParamSet(matcherType, name, defaultValue);
                }
            }
            if (httpParamSet.isEmpty()) continue;
            retVal.addHttpParamSet(httpParamSet);
        }
        return retVal;
    }
}

