/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.cookie;

import java.util.ArrayList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CookieHTTPHelper {
    private static final Logger log = Logger.getLogger(CookieHTTPHelper.class);

    public static void addCokiesToResponse(HttpServletResponse resp, ArrayList cookieObjects) {
        if (cookieObjects == null || cookieObjects.size() == 0) {
            log.debug((Object)"Nothing to add");
            return;
        }
        for (Cookie cookie : cookieObjects) {
            if (cookie == null) continue;
            resp.addCookie(cookie);
        }
    }

    public static void deleteCookies(HttpServletResponse resp, ArrayList cookieObjects) {
        if (cookieObjects == null) {
            return;
        }
        if (cookieObjects.size() == 0) {
            return;
        }
        for (Cookie cookie : cookieObjects) {
            Cookie delcookie = (Cookie)cookie.clone();
            delcookie.setValue("");
            delcookie.setMaxAge(0);
            resp.addCookie(delcookie);
        }
    }
}

