/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.impl;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.token.SSOClaim;
import org.eclipse.alf.security.sso.common.token.SSOClaimConstants;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenFactory;
import org.eclipse.alf.security.sso.common.token.SSOTokenPolicy;
import org.eclipse.alf.security.sso.common.token.saml.SAML1Attribute;
import org.eclipse.alf.security.sso.common.token.saml.SAML1Handler;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;
import org.eclipse.alf.security.sso.common.token.saml.policy.validator.SAML1PolicyValidatorImpl;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SignedSecurityToken;

public class SSOTokenImpl
implements SSOToken {
    static final Logger log = Logger.getLogger((String)SSOTokenImpl.class.getName());
    protected SAML1Handler samlHandler = null;
    protected SAML1PolicyValidatorImpl samlValidator = null;
    protected SAML1Policy samlProfilePolicy = null;

    private SSOTokenImpl() {
    }

    public SSOTokenImpl(SAML1Handler handler, SAML1PolicyValidatorImpl validator, SAML1Policy tokenProfilePolicy) throws SSOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Constructing SSOTokenImpl object");
        }
        if (handler == null) {
            throw new SSOException("Invalid arguments: missing SAML handler object");
        }
        if (validator == null) {
            throw new SSOException("Invalid arguments: missing SAML validator object");
        }
        this.samlHandler = handler;
        this.samlValidator = validator;
        this.samlProfilePolicy = tokenProfilePolicy;
    }

    public String getSubjectName() {
        return this.samlHandler.getNameIdentifier();
    }

    public X509Certificate getSubjectX509Certificate() throws SSOException {
        return this.samlHandler.getSubjectX509Certificate();
    }

    public PublicKey getSubjectPublicKey() throws SSOException {
        return this.samlHandler.getSubjectPublicKey();
    }

    public Date getIssueInstant() {
        return this.samlHandler.getIssueInstant();
    }

    public Date getNotBefore() {
        return this.samlHandler.getNotBefore();
    }

    public Date getNotOnOrAfter() {
        return this.samlHandler.getNotOnOrAfter();
    }

    public String[] getTargetRelyingParties() {
        return this.samlHandler.getAudienceRestrictions();
    }

    public String getTokenType() {
        SSOClaim claim = this.getSSOClaim(SSOClaimConstants.CLAIM_ALF_TICKET_TYPE);
        if (claim == null) {
            return null;
        }
        if (claim.getValue().equals("http://www.eclipse.org/ALF/1.0/claims/TicketType#TGT")) {
            return "http://www.eclipse.org/ALF/1.0/claims/TicketType#TGT";
        }
        if (claim.getValue().equals("http://www.eclipse.org/ALF/1.0/claims/TicketType#ST")) {
            return "http://www.eclipse.org/ALF/1.0/claims/TicketType#ST";
        }
        return "UNKNOWN";
    }

    public String getNativeTokenType() {
        return this.samlHandler.getTokenType();
    }

    public String getNativeTokenVersion() {
        return this.samlHandler.getTokenVersion();
    }

    public QName getNativeTokenQName() {
        return this.samlHandler.getTokenQName();
    }

    public String getIssuer() {
        return this.samlHandler.getIssuer();
    }

    public Object getNativeObject() {
        return this.samlHandler.getNativeObject();
    }

    public void setValidationPolicy(SSOTokenPolicy profilePolicy) {
        this.samlProfilePolicy = (SAML1Policy)profilePolicy;
    }

    public SSOTokenPolicy getValidationPolicy() {
        return this.samlProfilePolicy;
    }

    public ExtendedResult validateToken() {
        return this.samlValidator.validate(this.samlHandler, this.samlProfilePolicy);
    }

    public ExtendedResult validateToken(SSOTokenPolicy profilePolicy) {
        return this.samlValidator.validate(this.samlHandler, (SAML1Policy)profilePolicy);
    }

    public boolean isExpired() {
        ExtendedResult result = this.samlValidator.validateExpiration(this.samlHandler, this.samlProfilePolicy);
        return !result.isSuccess();
    }

    public boolean compareTo(SSOToken token) {
        return this.samlHandler.compareTo(token.getNativeObject());
    }

    public SignedSecurityToken toSecurityToken() {
        return this.samlHandler.toSecurityToken();
    }

    public String toString() {
        return ((Object)this.samlHandler).toString();
    }

    public OMElement toOM() throws SSOException {
        return this.samlHandler.toOM();
    }

    public boolean isSSOTokenElement(OMElement element) {
        return this.samlHandler.isSAMLElementShallow(element);
    }

    public Iterator getSSOClaims() {
        ArrayList<SSOClaim> retVal = new ArrayList<SSOClaim>();
        Iterator it = this.samlHandler.getAttributes();
        if (it != null) {
            while (it.hasNext()) {
                SAML1Attribute attr = (SAML1Attribute)it.next();
                QName claimName = new QName(attr.getNamespaceURI(), attr.getName());
                SSOClaim claim = SSOTokenFactory.createSSOClaim(claimName, attr.getValues());
                retVal.add(claim);
            }
        }
        return retVal.iterator();
    }

    public SSOClaim getSSOClaim(QName claimName) {
        SAML1Attribute attr = this.samlHandler.getAttribute(claimName.getLocalPart(), claimName.getNamespaceURI());
        if (attr == null) {
            return null;
        }
        SSOClaim claim = SSOTokenFactory.createSSOClaim(attr.getName(), attr.getNamespaceURI(), attr.getValues());
        claim.setLifetime(attr.getLifetime());
        return claim;
    }
}

