/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.builder;

import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.NameIdentifierPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.BasePolicyBuilder;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class NameIdentifierPolicyBuilder
extends BasePolicyBuilder {
    private static final Logger log = Logger.getLogger(NameIdentifierPolicyBuilder.class);
    public static final String NAME_IDENTIFIER_POLICY_LN = "NameIdentifierPolicy";
    public static final String MUST_INCLUDE_LN = "MustInclude";
    public static final String DISALLOWED_NAME_IDENTIFIERS_LN = "DisallowedNameIdentifiers";
    public static final String NAME_IDENTIFIER_LN = "NameIdentifier";
    public static final String NAME_QUALIFIER_LN = "NameQualifier";
    public static final String NAME_FORMAT_LN = "NameFormat";

    public String getLocalName() {
        return NAME_IDENTIFIER_POLICY_LN;
    }

    public BasePolicy build(OMElement element) throws SSOException {
        return this.build(element, null);
    }

    public BasePolicy build(OMElement element, BasePolicy basePolicy) throws SSOException {
        OMElement disallowedNameIdentifiersEl;
        if (element == null) {
            log.warn((Object)"NameIdentifierPolicyBuilder.build(null) called");
            return basePolicy;
        }
        OMElement el = element.getFirstChildWithName(new QName(this.getLocalName()));
        if (el == null) {
            log.error((Object)"NameIdentifierPolicyBuilder.build(): policy local name not found");
            return basePolicy;
        }
        NameIdentifierPolicy nameIdentifierPolicy = null;
        nameIdentifierPolicy = basePolicy != null ? (NameIdentifierPolicy)basePolicy : new NameIdentifierPolicy();
        if (SSOHelper.toBoolean(this.getAttribute(el, "override"), nameIdentifierPolicy.getOverride())) {
            log.debug((Object)"NameIdentifierPolicyBuilder.build(): Overriding previously defined policy");
            nameIdentifierPolicy = new NameIdentifierPolicy();
        }
        nameIdentifierPolicy.setEnforced(SSOHelper.toBoolean(this.getAttribute(el, "enforce"), nameIdentifierPolicy.getEnforced()));
        OMElement mustIncludeEl = el.getFirstChildWithName(new QName(MUST_INCLUDE_LN));
        if (mustIncludeEl != null) {
            nameIdentifierPolicy.setMustInclude(SSOHelper.toBoolean(mustIncludeEl.getText(), nameIdentifierPolicy.getMustInclude()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Name identifier policy: Parsed  <MustInclude> element: " + nameIdentifierPolicy.getMustInclude()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Name identifier policy: Missing  <MustInclude> element");
        }
        if ((disallowedNameIdentifiersEl = el.getFirstChildWithName(new QName(DISALLOWED_NAME_IDENTIFIERS_LN))) != null) {
            Iterator it = disallowedNameIdentifiersEl.getChildrenWithName(new QName(NAME_IDENTIFIER_LN));
            if (it != null) {
                while (it.hasNext()) {
                    OMElement next = (OMElement)it.next();
                    String nameQualifier = "*";
                    OMElement nameQualifierEl = next.getFirstChildWithName(new QName(NAME_QUALIFIER_LN));
                    if (nameQualifierEl != null) {
                        String nq = nameQualifierEl.getText();
                        if (StringHelper.isNotBlank(nq)) {
                            nameQualifier = nq;
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)"Empty value in  <NameQualifier> element found in policy. Defaulting to '*'");
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"No <NameQualifier> elements found in policy. Defaulting to '*'");
                    }
                    HashSet<String> nameFormats = new HashSet<String>();
                    Iterator nameFormatIt = next.getChildrenWithName(new QName(NAME_FORMAT_LN));
                    if (nameFormatIt != null) {
                        while (nameFormatIt.hasNext()) {
                            OMElement nameFormatEl = (OMElement)nameFormatIt.next();
                            String nameFormat = nameFormatEl.getText();
                            if (StringHelper.isNotBlank(nameFormat)) {
                                nameFormats.add(nameFormat);
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)(nameFormat + " added to policy disallowed name format list"));
                                continue;
                            }
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"Found + empty <NameFormat> element, skipped");
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"No <NameFormat> elements found in policy.");
                    }
                    nameIdentifierPolicy.addDisallowedNameIdentifier(nameQualifier, nameFormats);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"No <NameIdentifier> elements found in policy");
            }
        }
        return nameIdentifierPolicy;
    }
}

