/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.validator;

import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.token.SSOTokenValidationResult;
import org.eclipse.alf.security.sso.common.token.saml.SAML1Handler;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.NameIdentifierPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.validator.BasePolicyValidator;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class NameIdentifierPolicyValidator
extends BasePolicyValidator {
    private static final Logger log = Logger.getLogger(NameIdentifierPolicyValidator.class);
    protected static final String FORMAT_UNSPECIFIED = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
    protected static final String FORMAT_EMAIL = "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress";
    protected static final String FORMAT_X509_SUBJECT_NAME = "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName";
    protected static final String FORMAT_WINDOWS_DOMAIN_QUALIFIED_NAME = "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName";

    protected boolean validateFormatUnspecified(String nameIdentifier) {
        return true;
    }

    protected boolean validateFormatEmail(String nameIdentifier) {
        return true;
    }

    protected boolean validateFormatX509SubjectName(String nameIdentifier) {
        return true;
    }

    protected boolean validateFormatWindowsDomainQualifiedName(String nameIdentifier) {
        return true;
    }

    public ExtendedResult validate(SAML1Handler samlHandler, BasePolicy policy) {
        SSOTokenValidationResult result = new SSOTokenValidationResult();
        NameIdentifierPolicy nameIdentifierPolicy = (NameIdentifierPolicy)policy;
        String tokenNameIdentifier = samlHandler.getNameIdentifier();
        String tokenNameIdentifierFormat = samlHandler.getNameIdentifierFormat();
        String tokenNameIdentifierQualifier = samlHandler.getNameIdentifierQualifier();
        boolean isAllowed = true;
        if (StringHelper.isBlank(tokenNameIdentifier)) {
            if (nameIdentifierPolicy.getMustInclude()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Name identifier policy matching: Missing name identifier in token. Policy requires to be included");
                }
                result.setCode(150);
                return result;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Name identifier policy matching: Missing name identifier in token. Policy doesn't requires to be included. Policy validation OK");
            }
        } else {
            if (StringHelper.isNotBlank(tokenNameIdentifierQualifier)) {
                tokenNameIdentifierQualifier = "*";
            }
            Set disallowed = null;
            disallowed = nameIdentifierPolicy.getDisallowedNameIdentifierFormats(tokenNameIdentifierQualifier);
            if (disallowed != null) {
                if (disallowed.contains(tokenNameIdentifierFormat)) {
                    isAllowed = true;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Name identifier policy matching: [" + tokenNameIdentifierFormat + "] is on the disallowed list"));
                    }
                } else if (disallowed.contains("*")) {
                    isAllowed = true;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Name identifier policy matching: [" + tokenNameIdentifierFormat + "] is on the disallowed list due to all formats disallowed"));
                    }
                }
            } else {
                disallowed = nameIdentifierPolicy.getDisallowedNameIdentifierFormats("*");
                if (disallowed != null) {
                    if (disallowed.contains(tokenNameIdentifierFormat)) {
                        isAllowed = true;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Name identifier policy matching: [" + tokenNameIdentifierFormat + "] is on the disallowed list from '*' name qualifier policy"));
                        }
                    } else if (disallowed.contains("*")) {
                        isAllowed = true;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Name identifier policy matching: [" + tokenNameIdentifierFormat + "] is on the disallowed list due to all formats disallowed"));
                        }
                    }
                }
            }
            if (!isAllowed) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Name identifier policy matching: [" + tokenNameIdentifierFormat + "] is disallowed, failing validaton"));
                }
                result.setCode(160);
                return result;
            }
            if (tokenNameIdentifierFormat.equals(FORMAT_UNSPECIFIED)) {
                if (!this.validateFormatUnspecified(tokenNameIdentifier) && log.isDebugEnabled()) {
                    log.debug((Object)("Name identifier policy matching: validate(\"" + tokenNameIdentifierFormat + "\",\"" + tokenNameIdentifier + "\") failed"));
                }
            } else if (tokenNameIdentifierFormat.equals(FORMAT_EMAIL)) {
                if (!this.validateFormatEmail(tokenNameIdentifier) && log.isDebugEnabled()) {
                    log.debug((Object)("Name identifier policy matching: validate(\"" + tokenNameIdentifierFormat + "\",\"" + tokenNameIdentifier + "\") failed"));
                }
            } else if (tokenNameIdentifierFormat.equals(FORMAT_X509_SUBJECT_NAME)) {
                if (!this.validateFormatX509SubjectName(tokenNameIdentifier) && log.isDebugEnabled()) {
                    log.debug((Object)("Name identifier policy matching: validate(\"" + tokenNameIdentifierFormat + "\",\"" + tokenNameIdentifier + "\") failed"));
                }
            } else if (tokenNameIdentifierFormat.equals(FORMAT_WINDOWS_DOMAIN_QUALIFIED_NAME) && !this.validateFormatWindowsDomainQualifiedName(tokenNameIdentifier) && log.isDebugEnabled()) {
                log.debug((Object)("Name identifier policy matching: validate(\"" + tokenNameIdentifierFormat + "\",\"" + tokenNameIdentifier + "\") failed"));
            }
        }
        result.setCode(0);
        return result;
    }
}

