/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.Base64;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.model.WSAbstractFactory;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityTokenResponse;

public class SSOHelper {
    private static final Logger log = Logger.getLogger(SSOHelper.class);
    public static final String ZULU_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public static boolean isPOSTFormRequest(HttpServletRequest req) {
        int semicolon;
        if (!req.getMethod().equalsIgnoreCase("POST")) {
            return false;
        }
        String contentType = req.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        return "application/x-www-form-urlencoded".equals(contentType = (semicolon = contentType.indexOf(59)) >= 0 ? contentType.substring(0, semicolon).trim() : contentType.trim());
    }

    public static boolean isRSTRElement(OMElement element) {
        if (element == null) {
            return false;
        }
        RequestSecurityTokenResponse rstr = WSAbstractFactory.getWSTObjectFactory().createRequestSecurityTokenResponse();
        try {
            if (!rstr.isCompatibleElement(element)) {
                return false;
            }
        }
        catch (SSOException e) {
            log.error((Object)"Exception caught while checking RSTR element");
            return false;
        }
        return true;
    }

    public static boolean isRSTElement(OMElement element) {
        if (element == null) {
            return false;
        }
        RequestSecurityToken rst = WSAbstractFactory.getWSTObjectFactory().createRequestSecurityToken();
        try {
            if (!rst.isCompatibleElement(element)) {
                return false;
            }
        }
        catch (SSOException e) {
            return false;
        }
        return true;
    }

    public static boolean isSupportedSecutityToken(Iterator supportedTokenList, String tokenTypeURI) {
        Iterator it = supportedTokenList;
        boolean found = false;
        while (it.hasNext()) {
            String current = (String)it.next();
            if (!tokenTypeURI.equals(current)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static boolean isURLValid(String urlString) {
        if (urlString == null || urlString.trim().length() == 0) {
            return false;
        }
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            url = null;
        }
        return url == null;
    }

    public static boolean isInZuluTime(String zuluTime) {
        return SSOHelper.fromZuluTime(zuluTime) != null;
    }

    public static Date fromZuluTime(String xmlTime) {
        if (xmlTime == null || xmlTime.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(ZULU_TIME_FORMAT);
        Date time = null;
        try {
            time = formatter.parse(xmlTime);
        }
        catch (ParseException e) {
            time = null;
        }
        return time;
    }

    public static String formatInZuluTime(Date time) {
        SimpleDateFormat formatter = new SimpleDateFormat(ZULU_TIME_FORMAT);
        return formatter.format(time);
    }

    public static String nowInZuluTime() {
        SimpleDateFormat formatter = new SimpleDateFormat(ZULU_TIME_FORMAT);
        return formatter.format(new Date(System.currentTimeMillis()));
    }

    public static String B64Encode(String s) {
        if (s == null) {
            return null;
        }
        if (s.trim().length() == 0) {
            return s;
        }
        try {
            return Base64.encode((byte[])s.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String B64Decode(String s) {
        if (s == null) {
            return null;
        }
        if (s.trim().length() == 0) {
            return s;
        }
        byte[] b = Base64.decode((String)s);
        if (b == null) {
            return null;
        }
        try {
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static boolean toBoolean(String value, boolean defaultValue) {
        if (StringHelper.isBlank(value)) {
            return defaultValue;
        }
        if (value.compareToIgnoreCase("true") == 0 || value.compareToIgnoreCase("yes") == 0 || value.compareToIgnoreCase("1") == 0) {
            return true;
        }
        if (value.compareToIgnoreCase("false") == 0 || value.compareToIgnoreCase("no") == 0 || value.compareToIgnoreCase("0") == 0) {
            return false;
        }
        return defaultValue;
    }

    public static int min(int m, int n) {
        return m <= n ? m : n;
    }
}

