/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.federation.passive;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedPassiveException;

public abstract class WSFedData
implements Cloneable {
    protected String wa = null;
    protected String wreply = null;
    protected String wres = null;
    protected String wctx = null;
    protected String wp = null;
    protected String wct = null;
    protected String wtrealm = null;
    protected String wreq = null;
    protected String wreqptr = null;
    protected String wresult = null;
    protected String wresultptr = null;
    protected String wattr = null;
    protected String wpseudo = null;

    protected WSFedData() {
    }

    public WSFedData(WSFedData other) {
        this.copy(other);
    }

    public void copy(WSFedData other) {
        this.setWa(other.getWa());
        this.setWattr(other.getWattr());
        this.setWct(other.getWct());
        this.setWctx(other.getWctx());
        this.setWp(other.getWp());
        this.setWpseudo(other.getWpseudo());
        this.setWreply(other.getWreply());
        this.setWreq(other.getWreq());
        this.setWreqptr(other.getWreqptr());
        this.setWres(other.getWres());
        this.setWresult(other.getWresultptr());
        this.setWresultptr(other.getWresultptr());
        this.setWtrealm(other.getWtrealm());
    }

    public void copyDeep(WSFedData other) {
        this.setWa(other.getWa() != null ? new String(other.getWa()) : null);
        this.setWattr(other.getWattr() != null ? new String(other.getWattr()) : null);
        this.setWct(other.getWct() != null ? new String(other.getWct()) : null);
        this.setWctx(other.getWctx() != null ? new String(other.getWctx()) : null);
        this.setWp(other.getWp() != null ? new String(other.getWp()) : null);
        this.setWpseudo(other.getWpseudo() != null ? new String(other.getWpseudo()) : null);
        this.setWreply(other.getWreply() != null ? new String(other.getWreply()) : null);
        this.setWreq(other.getWreq() != null ? new String(other.getWreq()) : null);
        this.setWreqptr(other.getWreqptr() != null ? new String(other.getWreqptr()) : null);
        this.setWres(other.getWres() != null ? new String(other.getWres()) : null);
        this.setWresult(other.getWresult() != null ? new String(other.getWresult()) : null);
        this.setWresultptr(other.getWresultptr() != null ? new String(other.getWresultptr()) : null);
        this.setWtrealm(other.getWtrealm() != null ? new String(other.getWtrealm()) : null);
    }

    public void reset() {
        this.setWa(null);
        this.setWattr(null);
        this.setWct(null);
        this.setWctx(null);
        this.setWp(null);
        this.setWpseudo(null);
        this.setWreply(null);
        this.setWreq(null);
        this.setWreqptr(null);
        this.setWres(null);
        this.setWresult(null);
        this.setWresultptr(null);
        this.setWtrealm(null);
    }

    public boolean isEmpty() {
        if (StringHelper.isNotBlank(this.getWa())) {
            return false;
        }
        if (StringHelper.isNotBlank(this.getWattr())) {
            return false;
        }
        if (StringHelper.isNotBlank(this.getWct())) {
            return false;
        }
        if (StringHelper.isNotBlank(this.getWctx())) {
            return false;
        }
        if (StringHelper.isNotBlank(this.getWp())) {
            return false;
        }
        if (StringHelper.isNotBlank(this.getWpseudo())) {
            return false;
        }
        if (StringHelper.isNotBlank(this.getWreply())) {
            return false;
        }
        if (StringHelper.isNotBlank(this.getWreq())) {
            return false;
        }
        if (StringHelper.isNotBlank(this.getWreqptr())) {
            return false;
        }
        if (StringHelper.isNotBlank(this.getWres())) {
            return false;
        }
        if (StringHelper.isNotBlank(this.getWresult())) {
            return false;
        }
        if (StringHelper.isNotBlank(this.getWresultptr())) {
            return false;
        }
        return !StringHelper.isNotBlank(this.getWtrealm());
    }

    public boolean isSigninAction() {
        if (this.wa != null) {
            return this.wa.equals("wsignin1.0");
        }
        return false;
    }

    public boolean isSignoutAction() {
        if (this.wa != null) {
            return this.wa.equals("wsignout1.0");
        }
        return false;
    }

    public boolean isSignoutCleanupAction() {
        if (this.wa != null) {
            return this.wa.equals("wsignoutcleanup1.0");
        }
        return false;
    }

    public boolean isAttributeAction() {
        if (this.wa != null) {
            return this.wa.equals("wattr1.0");
        }
        return false;
    }

    public boolean isPseudonymAction() {
        if (this.wa != null) {
            return this.wa.equals("wpseudo1.0");
        }
        return false;
    }

    public Iterator getParamNames() {
        ArrayList<String> paramNames = new ArrayList<String>();
        paramNames.add("wa");
        paramNames.add("wreply");
        paramNames.add("wres");
        paramNames.add("wctx");
        paramNames.add("wp");
        paramNames.add("wct");
        paramNames.add("wtrealm");
        paramNames.add("wreq");
        paramNames.add("wreqptr");
        paramNames.add("wattr");
        paramNames.add("wpseudo");
        paramNames.add("wresult");
        paramNames.add("wresultptr");
        return paramNames.iterator();
    }

    public Iterator getRequestParamNames() {
        ArrayList<String> reqParamNames = new ArrayList<String>();
        reqParamNames.add("wa");
        reqParamNames.add("wreply");
        reqParamNames.add("wres");
        reqParamNames.add("wctx");
        reqParamNames.add("wp");
        reqParamNames.add("wct");
        reqParamNames.add("wtrealm");
        reqParamNames.add("wreq");
        reqParamNames.add("wreqptr");
        reqParamNames.add("wattr");
        reqParamNames.add("wpseudo");
        return reqParamNames.iterator();
    }

    public Iterator getResponseParamNames() {
        ArrayList<String> respParamNames = new ArrayList<String>();
        respParamNames.add("wa");
        if (this.isSigninAction()) {
            respParamNames.add("wctx");
            respParamNames.add("wresult");
            respParamNames.add("wresultptr");
        } else if (!this.isSignoutAction() && !this.isSignoutCleanupAction()) {
            if (this.isAttributeAction()) {
                respParamNames.add("wresult");
            } else if (this.isPseudonymAction()) {
                respParamNames.add("wresult");
            }
        }
        return respParamNames.iterator();
    }

    public String getWa() {
        return this.wa;
    }

    public void setWa(String wa) {
        this.wa = StringHelper.isBlank(wa) ? null : wa.trim();
    }

    public boolean validateWa() {
        if (this.wa != null) {
            return this.wa.equals("wattr1.0") || this.wa.equals("wpseudo1.0") || this.wa.equals("wsignin1.0") || this.wa.equals("wsignout1.0") || this.wa.equals("wsignoutcleanup1.0");
        }
        return true;
    }

    public String getWct() {
        return this.wct;
    }

    public void setWct(String wct) {
        this.wct = StringHelper.isBlank(wct) ? null : wct.trim();
    }

    public boolean validateWct() {
        return this.wct == null || SSOHelper.isInZuluTime(this.wct);
    }

    public String getWctx() {
        return this.wctx;
    }

    public void setWctx(String wctx) {
        this.wctx = StringHelper.isBlank(wctx) ? null : wctx.trim();
    }

    public boolean validateWctx() {
        return true;
    }

    public String getWp() {
        return this.wp;
    }

    public void setWp(String wp) {
        this.wp = StringHelper.isBlank(wp) ? null : wp.trim();
    }

    public boolean validateWp() {
        return true;
    }

    public String getWreply() {
        return this.wreply;
    }

    public void setWreply(String wreply) {
        this.wreply = StringHelper.isBlank(wreply) ? null : wreply.trim();
    }

    public boolean validateWreply() {
        return this.wreply == null || !SSOHelper.isURLValid(this.wreply);
    }

    public String getWres() {
        return this.wres;
    }

    public void setWres(String wres) {
        this.wres = StringHelper.isBlank(wres) ? null : wres.trim();
    }

    public boolean validateWres() {
        return this.wres == null || !SSOHelper.isURLValid(this.wres);
    }

    public String getWattr() {
        return this.wattr;
    }

    public void setWattr(String wattr) {
        this.wattr = StringHelper.isBlank(wattr) ? null : wattr.trim();
    }

    public boolean validateWattr() {
        return true;
    }

    public String getWpseudo() {
        return this.wpseudo;
    }

    public void setWpseudo(String wpseudo) {
        this.wpseudo = StringHelper.isBlank(wpseudo) ? null : wpseudo.trim();
    }

    public boolean validateWpseudo() {
        return true;
    }

    public String getWreq() {
        return this.wreq;
    }

    public void setWreq(String wreq) {
        this.wreq = StringHelper.isBlank(wreq) ? null : wreq.trim();
    }

    public boolean validateWreq() {
        return true;
    }

    public String getWreqptr() {
        return this.wreqptr;
    }

    public void setWreqptr(String wreqptr) {
        this.wreqptr = StringHelper.isBlank(wreqptr) ? null : wreqptr.trim();
    }

    public boolean validateWreqptr() {
        return true;
    }

    public String getWresult() {
        return this.wresult;
    }

    public void setWresult(String wresult) {
        this.wresult = StringHelper.isBlank(wresult) ? null : wresult.trim();
    }

    public boolean validateWresult() {
        return true;
    }

    public String getWresultptr() {
        return this.wresultptr;
    }

    public void setWresultptr(String wresultptr) {
        this.wresultptr = StringHelper.isBlank(wresultptr) ? null : wresultptr.trim();
    }

    public boolean validateWresultptr() {
        return true;
    }

    public String getWtrealm() {
        return this.wtrealm;
    }

    public void setWtrealm(String wtrealm) {
        this.wtrealm = StringHelper.isBlank(wtrealm) ? null : wtrealm.trim();
    }

    public boolean validateWrealm() {
        return true;
    }

    public void set(String paramName, String paramValue) throws WSFedPassiveException {
        if (StringHelper.isBlank(paramName)) {
            throw new WSFedPassiveException("Empty WS-Federation parameter name");
        }
        if ("wa".equals(paramName)) {
            this.setWa(paramValue);
        } else if ("wreply".equals(paramName)) {
            this.setWreply(paramValue);
        } else if ("wres".equals(paramName)) {
            this.setWres(paramValue);
        } else if ("wctx".equals(paramName)) {
            this.setWctx(paramValue);
        } else if ("wp".equals(paramName)) {
            this.setWp(paramValue);
        } else if ("wct".equals(paramName)) {
            this.setWct(paramValue);
        } else if ("wtrealm".equals(paramName)) {
            this.setWtrealm(paramValue);
        } else if ("wreq".equals(paramName)) {
            this.setWreq(paramValue);
        } else if ("wreqptr".equals(paramName)) {
            this.setWreqptr(paramValue);
        } else if ("wattr".equals(paramName)) {
            this.setWattr(paramValue);
        } else if ("wpseudo".equals(paramName)) {
            this.setWpseudo(paramValue);
        } else if ("wresult".equals(paramName)) {
            this.setWresult(paramValue);
        } else if ("wresultptr".equals(paramName)) {
            this.setWresultptr(paramValue);
        } else {
            throw new WSFedPassiveException("Unknown parameter name: " + paramName);
        }
    }

    public String get(String paramName) throws WSFedPassiveException {
        if (StringHelper.isBlank(paramName)) {
            throw new WSFedPassiveException("Empty WS-Federation parameter name");
        }
        if ("wa".equals(paramName)) {
            return this.getWa();
        }
        if ("wreply".equals(paramName)) {
            return this.getWreply();
        }
        if ("wres".equals(paramName)) {
            return this.getWres();
        }
        if ("wctx".equals(paramName)) {
            return this.getWctx();
        }
        if ("wp".equals(paramName)) {
            return this.getWp();
        }
        if ("wct".equals(paramName)) {
            return this.getWct();
        }
        if ("wtrealm".equals(paramName)) {
            return this.getWtrealm();
        }
        if ("wreq".equals(paramName)) {
            return this.getWreq();
        }
        if ("wreqptr".equals(paramName)) {
            return this.getWreqptr();
        }
        if ("wattr".equals(paramName)) {
            return this.getWattr();
        }
        if ("wpseudo".equals(paramName)) {
            return this.getWpseudo();
        }
        if ("wresult".equals(paramName)) {
            return this.getWresult();
        }
        if ("wresultptr".equals(paramName)) {
            return this.getWresultptr();
        }
        throw new WSFedPassiveException("Unknown parameter name: " + paramName);
    }

    private static String helperPrintElement(String paramName, String paramValue, boolean includeEmpty) {
        StringBuffer sb = new StringBuffer();
        if (StringHelper.isNotBlank(paramValue)) {
            sb.append(paramName);
            sb.append("=");
            if (StringHelper.isBlank(paramValue)) {
                sb.append(", ");
            } else {
                sb.append("\"");
                sb.append(paramValue);
                sb.append("\", ");
            }
        } else if (StringHelper.isBlank(paramValue) && includeEmpty) {
            sb.append(paramName);
            sb.append("=, ");
        }
        return sb.toString();
    }

    public String printToString(boolean includeEmpty) {
        StringBuffer sb = new StringBuffer();
        sb.append("---request--\n");
        sb.append(WSFedData.helperPrintElement("wa", this.getWa(), includeEmpty));
        sb.append(WSFedData.helperPrintElement("wreply", this.getWreply(), includeEmpty));
        sb.append(WSFedData.helperPrintElement("wres", this.getWres(), includeEmpty));
        sb.append(WSFedData.helperPrintElement("wctx", this.getWctx(), includeEmpty));
        sb.append(WSFedData.helperPrintElement("wp", this.getWp(), includeEmpty));
        sb.append(WSFedData.helperPrintElement("wct", this.getWct(), includeEmpty));
        sb.append(WSFedData.helperPrintElement("wtrealm", this.getWtrealm(), includeEmpty));
        sb.append(WSFedData.helperPrintElement("wreq", this.getWreq(), includeEmpty));
        sb.append(WSFedData.helperPrintElement("wreqptr", this.getWreqptr(), includeEmpty));
        sb.append(WSFedData.helperPrintElement("wattr", this.getWattr(), includeEmpty));
        sb.append(WSFedData.helperPrintElement("wpseudo", this.getWpseudo(), includeEmpty));
        sb.append("---response--\n");
        sb.append(WSFedData.helperPrintElement("wresult", this.getWresult(), includeEmpty));
        sb.append(WSFedData.helperPrintElement("wresultptr", this.getWresultptr(), includeEmpty));
        return sb.toString();
    }

    public String toString() {
        return this.printToString(false);
    }

    public int hashCode() {
        return this.printToString(true).hashCode();
    }

    public abstract Object clone();
}

