/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.message.soapengine;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportSender;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.RSTCallProxy;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.RSTDeserializer;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.receiver.SSORawXMLINOnlyMessageReceiverWithMsgCtxInit;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.transport.LocalMessageReceiverService;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.transport.SSOLocalTransportListener;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.transport.SSOLocalTransportReceiver;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.transport.SSOLocalTransportSender;

public class AbstractMessageDeserializer
extends RSTCallProxy {
    static final Logger log = Logger.getLogger(RSTDeserializer.class);
    private TransportOutDescription tOut;
    private TransportInDescription tIn;
    private AxisConfiguration axisConfig;
    private AxisService service;
    private ConfigurationContext receiverConfigurationContext;
    private AxisOperation axisOperation;
    private static final QName serviceName = new QName("LocalMessageReceiverService");
    private static final QName operationName = new QName("receiveMessage");

    public AbstractMessageDeserializer(String path, String axis2xml) throws SSOException {
        super(path, axis2xml);
    }

    protected void initialize(String path, String axis2xml) throws SSOException {
        super.initialize(path, axis2xml);
        try {
            this.axisConfig = this.configurationContext.getAxisConfiguration();
            this.tIn = new TransportInDescription("local");
            this.tIn.setReceiver((TransportListener)new SSOLocalTransportListener());
            this.axisConfig.addTransportIn(this.tIn);
            this.tOut = new TransportOutDescription("local");
            this.tOut.setSender((TransportSender)new SSOLocalTransportSender());
            this.axisConfig.addTransportOut(this.tOut);
            for (int i = 0; i < this.axis2ModulesToEngage.size(); ++i) {
                this.axisConfig.engageModule(new QName((String)this.axis2ModulesToEngage.get(i)));
            }
            this.receiverConfigurationContext = new ConfigurationContext(this.axisConfig);
            this.receiverConfigurationContext.setServicePath("myservices");
            SSOLocalTransportReceiver.setReceiverConfigurationContext(this.receiverConfigurationContext);
            this.service = new AxisService(serviceName.getLocalPart());
            this.service.addParameter(new Parameter("ServiceClass", (Object)LocalMessageReceiverService.class.getName()));
            this.axisOperation = new InOutAxisOperation(operationName);
            this.axisOperation.setMessageReceiver((MessageReceiver)new SSORawXMLINOnlyMessageReceiverWithMsgCtxInit());
            this.service.addOperation(this.axisOperation);
            this.service.setClassLoader(Thread.currentThread().getContextClassLoader());
            SSOLocalTransportReceiver.getReceiverConfigurationContext().getAxisConfiguration().addService(this.service);
        }
        catch (AxisFault e) {
            log.error((Object)"Error initialzing local message receiver", (Throwable)e);
            throw new SSOException("Error initialzing local message receiver");
        }
        this.options.setTransportOut(this.tOut);
    }

    public OMElement receiveSOAPMessage(String message) throws SSOException {
        OMElement result = null;
        OMElement payload = null;
        payload = XMLHelper.toOM(message);
        this.serviceClient.setOptions(this.options);
        SSOLocalTransportReceiver.setOptions(this.options);
        this.serviceClient.setTargetEPR(new EndpointReference("http://dummyserver/axis2/myservices/LocalMessageReceiverService/receiveMessage"));
        try {
            this.service.addParameter(this.securityContext.getOfc().getProperty());
            this.service.addParameter(this.securityContext.getIfc().getProperty());
        }
        catch (AxisFault e) {
            throw new SSOException("Error setting security parameters");
        }
        try {
            result = this.serviceClient.sendReceive(payload);
        }
        catch (AxisFault e) {
            log.error((Object)"Error sending and receiving payload", (Throwable)e);
            throw new SSOException("Error de-serializing message", e);
        }
        return result;
    }
}

