/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.message.soapengine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.SecCtxEmpty;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.SecurityContext;
import org.eclipse.alf.security.sso.common.ws.message.trust.RSTRequest;
import org.eclipse.alf.security.sso.common.ws.message.trust.issue.RSTIssueRequest;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustVersion;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityTokenResponse;

public class RSTCallProxy {
    static final Logger log = Logger.getLogger(RSTCallProxy.class);
    protected ConfigurationContext configurationContext = null;
    protected ServiceClient serviceClient = null;
    protected Options options = null;
    protected EndpointReference epr = null;
    protected OMElement requestPayload = null;
    protected OMElement responsePayload = null;
    protected MessageContext responseMessageContext = null;
    protected SecurityContext securityContext = new SecCtxEmpty();
    protected ArrayList axis2ModulesToEngage = new ArrayList();

    private RSTCallProxy() {
    }

    public RSTCallProxy(String axis2repo, String axis2xml) throws SSOException {
        this.initialize(axis2repo, axis2xml);
    }

    protected void initialize(String axis2repo, String axis2xml) throws SSOException {
        try {
            log.debug((Object)("Initializing axis2: axis2repo=" + axis2repo));
            log.debug((Object)("Initializing axis2: axis2xml=" + axis2xml));
            this.configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)axis2repo, (String)axis2xml);
            this.serviceClient = new ServiceClient(this.configurationContext, null);
            this.options = new Options();
            this.options.setTransportInProtocol("http");
            this.securityContext = new SecCtxEmpty();
            this.axis2ModulesToEngage.add("addressing");
            this.axis2ModulesToEngage.add("rampart");
        }
        catch (AxisFault e) {
            log.error((Object)("Failed to initialize client: " + e.getMessage()), (Throwable)e);
            throw new SSOException("Failed to initialize client: " + e.getMessage(), e);
        }
    }

    protected RSTIssueRequest createRSTIssueRequestfromRSTElement(OMElement rstEl) throws SSOException {
        RSTIssueRequest request = new RSTIssueRequest();
        WSTrust wst = null;
        OMNamespace incomingWstNS = rstEl.getNamespace();
        if (incomingWstNS.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2005/02/trust")) {
            wst = new WSTrust(WSTrustVersion.V1);
        } else if (incomingWstNS.getNamespaceURI().equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512")) {
            wst = new WSTrust(WSTrustVersion.V2);
        } else {
            log.error((Object)("RSTCallProxy.createRSTIssueRequestfromRSTElement. Unsupported WS-Trust version:[" + rstEl.toString() + "]"));
            throw new SSOException("Unsupported WS-Trust version in RST");
        }
        OMElement rstRequestTypeEl = rstEl.getFirstChildWithName(new QName(wst.getNamespace(), "RequestType"));
        if (rstRequestTypeEl == null) {
            log.error((Object)"RSTCallProxy.createRSTIssueRequestfromRSTElement. No <wst:RequestType> on RST");
            throw new SSOException("Could not find <wst:RequestType> element on RST");
        }
        String requestType = rstRequestTypeEl.getText();
        if (requestType == null || requestType.trim().length() == 0) {
            log.error((Object)"RSTCallProxy.createRSTIssueRequestfromRSTElement. Empty <wst:RequestType> on RST");
            throw new SSOException("Empty <wst:RequestType> element on RST");
        }
        String action = wst.getActionFromRequestType(requestType);
        if (action == null) {
            log.error((Object)"RSTCallProxy.createRSTIssueRequestfromRSTElement. Empty <wst:RequestType> element on RST");
            throw new SSOException("Unknown <wst:RequestType> element on RST");
        }
        request.setRawRST(rstEl);
        request.setAction(action);
        return request;
    }

    public RequestSecurityTokenResponse invoke(OMElement rstEl) throws SSOException, AxisFault {
        RSTIssueRequest request = this.createRSTIssueRequestfromRSTElement(rstEl);
        OMElement resultData = this.internalRSTInvoke(request);
        try {
            RequestSecurityTokenResponse RSTR = WSTrustObjectBuilder.buildRequestSecurityTokenResponse(resultData);
            if (log.isDebugEnabled()) {
                log.debug((Object)"RSTCallProxy.invoke. Successfully deserialized RSTR");
            }
            return RSTR;
        }
        catch (SSOException e) {
            log.error((Object)"RSTCallProxy.invoke. Error while deserializing RSTR from XML", (Throwable)e);
            throw new SSOException("RSTCallProxy.invoke. Error in parsing result");
        }
    }

    public RequestSecurityTokenResponse invoke(RSTRequest request) throws SSOException, AxisFault {
        OMElement resultData = this.internalRSTInvoke(request);
        try {
            RequestSecurityTokenResponse RSTR = WSTrustObjectBuilder.buildRequestSecurityTokenResponse(resultData);
            if (log.isDebugEnabled()) {
                log.debug((Object)"RSTCallProxy.invoke. Successfully deserialized RSTR");
            }
            return RSTR;
        }
        catch (SSOException e) {
            log.error((Object)"RSTCallProxy.invoke. Error while deserializing RSTR from XML", (Throwable)e);
            throw new SSOException("Error in parsing result");
        }
    }

    protected SOAPEnvelope createSOAPEnvelope(ServiceClient serviceClient, ArrayList headers, OMElement payload) {
        Iterator it;
        String soapVersionURI = serviceClient.getOptions().getSoapVersionURI();
        SOAPFactory soapFactory = null;
        soapFactory = "http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI) ? OMAbstractFactory.getSOAP12Factory() : OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        if (headers != null && (it = headers.iterator()) != null) {
            SOAPHeader soapHeader = envelope.getHeader();
            while (it.hasNext()) {
                SOAPHeaderBlock wsseHeader = (SOAPHeaderBlock)it.next();
                if (wsseHeader == null) continue;
                soapHeader.addChild((OMNode)wsseHeader);
            }
        }
        envelope.getBody().addChild((OMNode)payload);
        return envelope;
    }

    protected OMElement internalRSTInvoke(RSTRequest request) throws SSOException, AxisFault {
        if (request.getSecurityContext() != null) {
            this.setSecurityContext(request.getSecurityContext());
        }
        if (request.getEpr() != null) {
            this.setEpr(new EndpointReference(request.getEpr()));
        }
        OMElement reqPayload = request.toOM();
        return this.internalGenericInvoke(reqPayload, request.getAction());
    }

    protected OMElement internalGenericInvoke(OMElement request, String action) throws AxisFault {
        String newLine = System.getProperty("line.separator");
        this.requestPayload = request;
        this.options.setAction(action);
        this.serviceClient.setTargetEPR(this.epr);
        this.serviceClient.setOptions(this.options);
        log.debug((Object)("Entering. request=" + request.toString() + newLine + "    action=" + action));
        try {
            for (int i = 0; i < this.axis2ModulesToEngage.size(); ++i) {
                this.serviceClient.engageModule((String)this.axis2ModulesToEngage.get(i));
            }
            MessageContext messageContext = new MessageContext();
            messageContext.setServiceContext(this.serviceClient.getServiceContext());
            SOAPEnvelope envelope = this.createSOAPEnvelope(this.serviceClient, this.securityContext.getSecurityHeadersListAsOM(), this.requestPayload);
            messageContext.setEnvelope(envelope);
            OperationClient operationClient = this.serviceClient.createClient(ServiceClient.ANON_OUT_IN_OP);
            operationClient.addMessageContext(messageContext);
            log.debug((Object)"Before firing the request");
            operationClient.execute(true);
            log.debug((Object)"After firing the request");
            this.responseMessageContext = operationClient.getMessageContext("In");
            this.responsePayload = this.responseMessageContext.getEnvelope().getBody().getFirstElement();
        }
        catch (AxisFault e) {
            log.error((Object)"Axis fault", (Throwable)e);
            throw e;
        }
        return this.responsePayload;
    }

    public void setEpr(EndpointReference epr) {
        this.epr = epr;
        this.options.setTo(epr);
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
        this.options.setProperty("InflowSecurity", (Object)securityContext.getIfc().getProperty());
        this.options.setProperty("OutflowSecurity", (Object)securityContext.getOfc().getProperty());
        if (securityContext.getOptionProperties().size() > 0) {
            Map props = securityContext.getOptionProperties();
            Set keys = props.keySet();
            for (String key : keys) {
                Object value = props.get(key);
                this.options.setProperty(key, value);
            }
        }
        if (securityContext.getActor() != null) {
            this.options.setProperty("actor", (Object)securityContext.getActor());
        }
    }

    public OMElement getResponsePayload() {
        return this.responsePayload;
    }

    public MessageContext getResponseMessageContext() {
        return this.responseMessageContext;
    }

    public void setAxis2ModulesToEngage(String[] modules) {
        this.axis2ModulesToEngage = new ArrayList();
        if (modules == null) {
            return;
        }
        for (int i = 0; i < modules.length; ++i) {
            this.axis2ModulesToEngage.add(modules[i]);
        }
    }
}

