/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.message.soapengine.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.Base64;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.SOAPEngineConstants;

public class SerializingTransportSender
extends AbstractHandler
implements TransportSender {
    private static final long serialVersionUID = -5245866514826025561L;
    private ByteArrayOutputStream out;
    private ByteArrayOutputStream response;

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        try {
            ByteArrayInputStream in;
            String responseMessage = (String)msgContext.getOptions().getProperty("ALFSSO_RESPONSE_MESSAGE");
            if (responseMessage == null) {
                String b64Message = Base64.encode((byte[])msgContext.getEnvelope().toString().getBytes());
                String getSoapVersionURI = msgContext.getOptions().getSoapVersionURI();
                SOAPFactory soapFactory = getSoapVersionURI.equals("http://schemas.xmlsoap.org/soap/envelope/") ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
                SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
                OMFactory omfac = OMAbstractFactory.getOMFactory();
                OMElement xmlPayload = omfac.createOMElement("SerializedSOAPMessage", SOAPEngineConstants.SOAP_SERIALIZATION_OMNS);
                xmlPayload.setText(b64Message);
                envelope.getBody().addChild((OMNode)xmlPayload);
                SOAPEnvelope outputMessage = envelope;
                String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
                OMOutputFormat format = new OMOutputFormat();
                format.setDoOptimize(false);
                format.setDoingSWA(false);
                format.setCharSetEncoding(charSetEnc);
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                outputMessage.serializeAndConsume((OutputStream)output, format);
                output.flush();
                in = new ByteArrayInputStream(output.toByteArray());
            } else {
                in = new ByteArrayInputStream(responseMessage.getBytes("UTF-8"));
            }
            msgContext.setProperty("TRANSPORT_IN", (Object)in);
        }
        catch (Throwable e) {
            return Handler.InvocationResponse.ABORT;
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
    }

    public void finalizeSendWithOutputStreamFromIncomingConnection(MessageContext msgContext, OutputStream out) throws AxisFault {
        throw new UnsupportedOperationException();
    }

    public void finalizeSendWithToAddress(MessageContext msgContext, OutputStream out) throws AxisFault {
        try {
            ByteArrayInputStream in;
            String responseMessage = (String)msgContext.getOptions().getProperty("ALFSSO_RESPONSE_MESSAGE");
            if (responseMessage == null) {
                String b64Message = Base64.encode((byte[])this.out.toByteArray());
                String getSoapVersionURI = msgContext.getOptions().getSoapVersionURI();
                SOAPFactory soapFactory = getSoapVersionURI.equals("http://schemas.xmlsoap.org/soap/envelope/") ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
                SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
                OMFactory omfac = OMAbstractFactory.getOMFactory();
                OMElement xmlPayload = omfac.createOMElement("SerializedSOAPMessage", SOAPEngineConstants.SOAP_SERIALIZATION_OMNS);
                xmlPayload.setText(b64Message);
                envelope.getBody().addChild((OMNode)xmlPayload);
                SOAPEnvelope outputMessage = envelope;
                String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
                OMOutputFormat format = new OMOutputFormat();
                format.setDoOptimize(false);
                format.setDoingSWA(false);
                format.setCharSetEncoding(charSetEnc);
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                outputMessage.serializeAndConsume((OutputStream)output, format);
                output.flush();
                in = new ByteArrayInputStream(output.toByteArray());
            } else {
                in = new ByteArrayInputStream(responseMessage.getBytes("UTF-8"));
            }
            msgContext.setProperty("TRANSPORT_IN", (Object)in);
        }
        catch (Throwable e) {
            throw new AxisFault(e);
        }
    }

    protected OutputStream openTheConnection(EndpointReference epr, MessageContext msgContext) throws AxisFault {
        this.out = new ByteArrayOutputStream();
        return this.out;
    }

    public OutputStream startSendWithOutputStreamFromIncomingConnection(MessageContext msgContext, OutputStream out) throws AxisFault {
        throw new UnsupportedOperationException();
    }

    public OutputStream startSendWithToAddress(MessageContext msgContext, OutputStream out) throws AxisFault {
        return out;
    }

    OutputStream getResponse() {
        return this.response;
    }

    public void stop() {
    }
}

