/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.security.secext;

import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExt;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.Embedded;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.KeyIdentifier;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.Reference;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.SecurityTokenReference;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.impl.EmbeddedImpl;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.impl.KeyIdentifierImpl;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.impl.ReferenceImpl;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.impl.SecurityTokenReferenceImpl;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SAML1Token;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.UsernameToken;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.impl.SAML1TokenImpl;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.impl.UsernameTokenImpl;

public class WSSecExtObjectFactory {
    static final Logger log = Logger.getLogger(WSSecExtObjectFactory.class);
    protected WSSecExt wsse = null;

    public WSSecExtObjectFactory() {
        this.wsse = new WSSecExt();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Constructing WSSecExtObjectFactory() object");
        }
    }

    public WSSecExtObjectFactory(WSSecExt wsse) {
        this.wsse = wsse;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructing WSSecExtObjectFactory() object with version " + wsse.getVersion()));
        }
    }

    public UsernameToken createUsernameToken() {
        return new UsernameTokenImpl(this.wsse);
    }

    public UsernameToken createUsernameToken(String username, String password) {
        return new UsernameTokenImpl(this.wsse, username, password);
    }

    public SAML1Token createSAML1Token() {
        return new SAML1TokenImpl();
    }

    public SAML1Token createSAML1Token(Object nativeObject) {
        return new SAML1TokenImpl(nativeObject);
    }

    public Embedded createEmbedded() {
        return new EmbeddedImpl(this.wsse);
    }

    public KeyIdentifier createKeyIdentifier() {
        return new KeyIdentifierImpl(this.wsse);
    }

    public Reference createReference() {
        return new ReferenceImpl(this.wsse);
    }

    public SecurityTokenReference createSecurityTokenReference() {
        return new SecurityTokenReferenceImpl(this.wsse);
    }
}

