/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust.element.impl;

import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.GenericAttribute;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExtObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.SecurityTokenReference;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedSecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.BaseWSTrustObjectImpl;

public class RequestedSecurityTokenImpl
extends BaseWSTrustObjectImpl
implements RequestedSecurityToken {
    private static final Logger log = Logger.getLogger(RequestedSecurityTokenImpl.class);
    protected WSTrust wst;
    protected SecurityToken token;
    protected SecurityTokenReference tokenReference;

    public RequestedSecurityTokenImpl() {
        this.reset();
        this.wst = new WSTrust();
    }

    public RequestedSecurityTokenImpl(WSTrust wst) {
        this.reset();
        this.wst = wst;
    }

    public String getLocalName() {
        return "RequestedSecurityToken";
    }

    public void reset() {
        super.reset();
        this.tokenReference = null;
        this.token = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof RequestedSecurityTokenImpl) {
            RequestedSecurityTokenImpl otherRequestedSecurityTokenImpl = (RequestedSecurityTokenImpl)other;
            this.wst = otherRequestedSecurityTokenImpl.wst;
            this.tokenReference = otherRequestedSecurityTokenImpl.tokenReference;
            this.token = otherRequestedSecurityTokenImpl.token;
        }
    }

    public SecurityToken getSecurityToken() {
        return this.token;
    }

    public void setSecurityToken(SecurityToken securityToken) {
        this.token = securityToken;
        this.tokenReference = null;
        this.setDirty();
    }

    public SecurityTokenReference getSecurtityTokenReference() {
        return this.tokenReference;
    }

    public void setSecurtityTokenReference(SecurityTokenReference securityTokenReference) {
        this.tokenReference = securityTokenReference;
        this.token = null;
        this.setDirty();
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement requestedSecurityToken = this.wst.createOMElement(parent, this.getLocalName());
        if (this.token != null) {
            this.token.toOM(requestedSecurityToken);
        } else if (this.tokenReference != null) {
            this.tokenReference.toOM(requestedSecurityToken);
        }
        this.addAnyAttributesToElement(requestedSecurityToken);
        this.addAnyElementsToElementAsChildren(requestedSecurityToken);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + requestedSecurityToken.toString() + "]"));
        }
        return requestedSecurityToken;
    }

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        return this.baseIsCompatibleElementTrust(element, this.getLocalName()) != null;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        WSTrust wst = this.baseIsCompatibleElementTrust(element, this.getLocalName());
        if (wst == null) {
            return null;
        }
        log.debug((Object)"Parsing <wst:RequestedSecurityToken> element");
        RequestedSecurityTokenImpl requestedSecurityToken = new RequestedSecurityTokenImpl(wst);
        Iterator it = element.getAllAttributes();
        if (it != null) {
            while (it.hasNext()) {
                OMAttribute attr = (OMAttribute)it.next();
                requestedSecurityToken._anyAttr.add(new GenericAttribute(attr.getLocalName(), attr.getAttributeValue()));
            }
        }
        if ((it = element.getChildElements()) != null) {
            while (it.hasNext()) {
                OMElement workEl = (OMElement)it.next();
                String localName = workEl.getLocalName();
                if ("SecurityTokenReference".equals(localName)) {
                    requestedSecurityToken.tokenReference = WSSecExtObjectBuilder.buildSecurityTokenReference(workEl);
                    continue;
                }
                if (WSSecExtObjectBuilder.isKnownSecurityToken(workEl)) {
                    requestedSecurityToken.token = WSSecExtObjectBuilder.buildSecurityToken(workEl);
                    if (requestedSecurityToken.token != null) continue;
                    requestedSecurityToken._anyElement.add(workEl.cloneOMElement());
                    continue;
                }
                requestedSecurityToken._anyElement.add(workEl.cloneOMElement());
            }
        }
        requestedSecurityToken.setParseSource(element);
        this.copyFrom(requestedSecurityToken);
        return this;
    }

    public WSTrust getWSTrust() {
        return this.wst;
    }
}

