/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.editors.eventactionmap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.eclipse.alf.editors.eventactionmap.EventMapEditor;
import org.eclipse.alf.editors.eventactionmap.EventMapEditorScreen;
import org.eclipse.alf.editors.eventregistry.EventEditor;
import org.eclipse.alf.models.EventMap;
import org.eclipse.alf.models.RegisteredEvent;
import org.eclipse.alf.util.ArrayManager;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;

public class EventSelectionDialog
extends Dialog {
    private List selectedList;
    private List unselectedList;
    private EventMapEditorScreen eventMapScreen = null;
    private ArrayList unSelectedEvents;
    private String[] items;
    private String[] selectedItems;
    private Shell shell;
    private RegisteredEvent[] eventregArray;
    private static final int DIALOG_WIDTH = 645;
    private static final int DIALOG_HEIGHT = 450;

    public EventSelectionDialog(Shell shell, int n) {
        super(shell, n);
    }

    public EventSelectionDialog(Shell shell) {
        this(shell, 16);
    }

    public void open(EventMapEditorScreen eventMapEditorScreen) {
        Display display;
        this.eventMapScreen = eventMapEditorScreen;
        this.shell = new Shell(this.getParent(), 67680);
        GridLayout gridLayout = new GridLayout();
        this.shell.setLayout((Layout)gridLayout);
        this.shell.setSize(645, 450);
        this.shell.setText("Select ALF Events");
        this.unSelectedEvents = this.selectRegisterEvents();
        if (this.unSelectedEvents != null) {
            this.items = new String[this.unSelectedEvents.size()];
            display = this.unSelectedEvents.iterator();
            int n = 0;
            while (display.hasNext()) {
                this.items[n++] = display.next().toString();
            }
        }
        this.createContents();
        this.shell.open();
        this.shell.layout();
        display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createContents() {
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 2, false, false));
        label.setText("Available Events");
        new Label(composite, 0);
        Label label2 = new Label(composite, 0);
        label2.setLayoutData((Object)new GridData(4, 2, false, false));
        label2.setText("Selected Events");
        this.unselectedList = new List(composite, 2834);
        this.unselectedList.setLayoutData((Object)new GridData(218, 249));
        MouseTrackListener mouseTrackListener = new MouseTrackListener(){

            public void mouseHover(MouseEvent mouseEvent) {
                int n = EventSelectionDialog.this.unselectedList.getFocusIndex();
                String string = EventSelectionDialog.this.unselectedList.getItem(n);
                EventSelectionDialog.this.unselectedList.setToolTipText(string);
            }

            public void mouseEnter(MouseEvent mouseEvent) {
            }

            public void mouseExit(MouseEvent mouseEvent) {
            }
        };
        this.unselectedList.addMouseTrackListener(mouseTrackListener);
        if (null != this.items) {
            this.unselectedList.setItems(this.items);
        }
        this.unselectedList.setRedraw(true);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(2, 2, false, false));
        composite2.setLayout((Layout)new GridLayout());
        Button button = new Button(composite2, 0x1000000);
        button.setLayoutData((Object)new GridData(60, -1));
        button.setText(">");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                Object[] objectArray = EventSelectionDialog.this.unselectedList.getSelection();
                Object[] objectArray2 = ArrayManager.mergeArray(EventSelectionDialog.this.selectedItems, objectArray);
                if (null != objectArray2) {
                    EventSelectionDialog.access$102(EventSelectionDialog.this, new String[objectArray2.length]);
                    for (n = 0; n < objectArray2.length; ++n) {
                        ((EventSelectionDialog)EventSelectionDialog.this).selectedItems[n] = objectArray2[n].toString();
                    }
                }
                if (null != (objectArray2 = ArrayManager.deleteAndAdjust((Object[])EventSelectionDialog.this.items, objectArray))) {
                    EventSelectionDialog.access$202(EventSelectionDialog.this, new String[objectArray2.length]);
                    for (n = 0; n < objectArray2.length; ++n) {
                        ((EventSelectionDialog)EventSelectionDialog.this).items[n] = objectArray2[n].toString();
                    }
                }
                EventSelectionDialog.this.unselectedList.removeAll();
                EventSelectionDialog.this.selectedList.removeAll();
                if (null != EventSelectionDialog.this.items) {
                    EventSelectionDialog.this.unselectedList.setItems(EventSelectionDialog.this.items);
                }
                if (null != EventSelectionDialog.this.selectedItems) {
                    EventSelectionDialog.this.selectedList.setItems(EventSelectionDialog.this.selectedItems);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Button button2 = new Button(composite2, 0);
        button2.setLayoutData((Object)new GridData(60, -1));
        button2.setText(">>");
        button2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                Object[] objectArray = EventSelectionDialog.this.items;
                Object[] objectArray2 = ArrayManager.mergeArray(EventSelectionDialog.this.selectedItems, objectArray);
                if (null != objectArray2) {
                    EventSelectionDialog.access$102(EventSelectionDialog.this, new String[objectArray2.length]);
                    for (n = 0; n < objectArray2.length; ++n) {
                        ((EventSelectionDialog)EventSelectionDialog.this).selectedItems[n] = objectArray2[n].toString();
                    }
                }
                if (null != (objectArray2 = ArrayManager.deleteAndAdjust((Object[])EventSelectionDialog.this.items, objectArray))) {
                    EventSelectionDialog.access$202(EventSelectionDialog.this, new String[objectArray2.length]);
                    for (n = 0; n < objectArray2.length; ++n) {
                        ((EventSelectionDialog)EventSelectionDialog.this).items[n] = objectArray2[n].toString();
                    }
                }
                EventSelectionDialog.this.unselectedList.removeAll();
                EventSelectionDialog.this.selectedList.removeAll();
                if (null != EventSelectionDialog.this.items) {
                    EventSelectionDialog.this.unselectedList.setItems(EventSelectionDialog.this.items);
                }
                if (null != EventSelectionDialog.this.selectedItems) {
                    EventSelectionDialog.this.selectedList.setItems(EventSelectionDialog.this.selectedItems);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Button button3 = new Button(composite2, 0);
        button3.setLayoutData((Object)new GridData(60, -1));
        button3.setText("<");
        button3.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                Object[] objectArray = EventSelectionDialog.this.selectedList.getSelection();
                Object[] objectArray2 = ArrayManager.mergeArray(EventSelectionDialog.this.items, objectArray);
                if (null != objectArray2) {
                    EventSelectionDialog.access$202(EventSelectionDialog.this, new String[objectArray2.length]);
                    for (n = 0; n < objectArray2.length; ++n) {
                        ((EventSelectionDialog)EventSelectionDialog.this).items[n] = objectArray2[n].toString();
                    }
                }
                if (null != (objectArray2 = ArrayManager.deleteAndAdjust((Object[])EventSelectionDialog.this.selectedItems, objectArray))) {
                    EventSelectionDialog.access$102(EventSelectionDialog.this, new String[objectArray2.length]);
                    for (n = 0; n < objectArray2.length; ++n) {
                        ((EventSelectionDialog)EventSelectionDialog.this).selectedItems[n] = objectArray2[n].toString();
                    }
                }
                EventSelectionDialog.this.unselectedList.removeAll();
                EventSelectionDialog.this.selectedList.removeAll();
                if (null != EventSelectionDialog.this.items) {
                    EventSelectionDialog.this.unselectedList.setItems(EventSelectionDialog.this.items);
                }
                if (null != EventSelectionDialog.this.selectedItems) {
                    EventSelectionDialog.this.selectedList.setItems(EventSelectionDialog.this.selectedItems);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Button button4 = new Button(composite2, 0);
        button4.setLayoutData((Object)new GridData(60, -1));
        button4.setText("<<");
        button4.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                Object[] objectArray = EventSelectionDialog.this.selectedItems;
                Object[] objectArray2 = ArrayManager.mergeArray(EventSelectionDialog.this.items, objectArray);
                if (null != objectArray2) {
                    EventSelectionDialog.access$202(EventSelectionDialog.this, new String[objectArray2.length]);
                    for (n = 0; n < objectArray2.length; ++n) {
                        ((EventSelectionDialog)EventSelectionDialog.this).items[n] = objectArray2[n].toString();
                    }
                }
                if (null != (objectArray2 = ArrayManager.deleteAndAdjust((Object[])EventSelectionDialog.this.selectedItems, objectArray))) {
                    EventSelectionDialog.access$102(EventSelectionDialog.this, new String[objectArray2.length]);
                    for (n = 0; n < objectArray2.length; ++n) {
                        ((EventSelectionDialog)EventSelectionDialog.this).selectedItems[n] = objectArray2[n].toString();
                    }
                }
                EventSelectionDialog.this.unselectedList.removeAll();
                EventSelectionDialog.this.selectedList.removeAll();
                if (null != EventSelectionDialog.this.items) {
                    EventSelectionDialog.this.unselectedList.setItems(EventSelectionDialog.this.items);
                }
                if (null != EventSelectionDialog.this.selectedItems) {
                    EventSelectionDialog.this.selectedList.setItems(EventSelectionDialog.this.selectedItems);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.selectedList = new List(composite, 2834);
        this.selectedList.setLayoutData((Object)new GridData(218, 249));
        MouseTrackListener mouseTrackListener2 = new MouseTrackListener(){

            public void mouseHover(MouseEvent mouseEvent) {
                int n = EventSelectionDialog.this.selectedList.getFocusIndex();
                String string = EventSelectionDialog.this.selectedList.getItem(n);
                EventSelectionDialog.this.selectedList.setToolTipText(string);
            }

            public void mouseEnter(MouseEvent mouseEvent) {
            }

            public void mouseExit(MouseEvent mouseEvent) {
            }
        };
        this.selectedList.addMouseTrackListener(mouseTrackListener2);
        if (null != this.selectedItems) {
            this.selectedList.setItems(this.selectedItems);
        }
        this.selectedList.setRedraw(true);
        new Label(composite, 0);
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayoutData((Object)new GridData(2, 2, false, false));
        composite3.setLayout((Layout)new GridLayout(2, true));
        Button button5 = new Button(composite3, 0);
        button5.setLayoutData((Object)new GridData(50, -1));
        button5.setText("&Ok");
        button5.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EventMap eventMap;
                int n;
                ArrayList<EventMap> arrayList = new ArrayList<EventMap>();
                ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(EventSelectionDialog.this.selectedList.getItems()));
                EventMap[] eventMapArray = EventSelectionDialog.this.eventMapScreen.getEventmapregArray();
                if (eventMapArray != null) {
                    for (int i = 0; i < eventMapArray.length; ++i) {
                        arrayList.add(eventMapArray[i]);
                    }
                }
                ArrayList arrayList3 = EventSelectionDialog.this.getSelectedEvents(arrayList2);
                for (n = 0; n < arrayList3.size(); ++n) {
                    eventMap = new EventMap();
                    RegisteredEvent registeredEvent = (RegisteredEvent)arrayList3.get(n);
                    eventMap.setEventType(registeredEvent.getEventType());
                    eventMap.setObjectType(registeredEvent.getObjectType());
                    eventMap.setProduct(registeredEvent.getProduct());
                    eventMap.setProductInstance(registeredEvent.getProductInstance());
                    eventMap.setProductVersion(registeredEvent.getProductVersion());
                    eventMap.setEventMatchName(registeredEvent.getEventMatchName());
                    EventMapEditor eventMapEditor = new EventMapEditor();
                    String string = eventMapEditor.getEventMapFile().substring(0, eventMapEditor.getEventMapFile().indexOf("."));
                    eventMap.setApplicationName(string);
                    arrayList.add(eventMap);
                }
                eventMapArray = new EventMap[arrayList.size()];
                for (n = 0; n < arrayList.size(); ++n) {
                    eventMapArray[n] = eventMap = (EventMap)arrayList.get(n);
                }
                EventSelectionDialog.this.eventMapScreen.setEventmapregArray(eventMapArray);
                EventSelectionDialog.this.eventMapScreen.saveEventmapValues();
                ((Button)selectionEvent.getSource()).getShell().dispose();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Button button6 = new Button(composite3, 0);
        button6.setLayoutData((Object)new GridData(55, -1));
        button6.setText("&Cancel");
        button6.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ((Button)selectionEvent.getSource()).getShell().dispose();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        new Label(composite, 0);
        final Text text = new Text((Composite)this.shell, 2819);
        text.setLayoutData((Object)new GridData(4, 4, true, true));
        text.setEditable(false);
        this.unselectedList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                text.setText("");
                String[] stringArray = EventSelectionDialog.this.unselectedList.getSelection();
                for (int i = 0; i < stringArray.length; ++i) {
                    text.append(stringArray[i] + "\n");
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.selectedList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                text.setText("");
                String[] stringArray = EventSelectionDialog.this.selectedList.getSelection();
                for (int i = 0; i < stringArray.length; ++i) {
                    text.append(stringArray[i] + "\n");
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
    }

    private int eventExists(RegisteredEvent registeredEvent) {
        EventMap[] eventMapArray = this.eventMapScreen.getEventmapregArray();
        if (eventMapArray == null) {
            return -1;
        }
        for (int i = 0; i < eventMapArray.length; ++i) {
            if (!eventMapArray[i].getEventType().equals(registeredEvent.getEventType()) || !eventMapArray[i].getObjectType().equals(registeredEvent.getObjectType()) || !eventMapArray[i].getProduct().equals(registeredEvent.getProduct()) || !eventMapArray[i].getProductInstance().equals(registeredEvent.getProductInstance()) || !eventMapArray[i].getProductVersion().equals(registeredEvent.getProductVersion())) continue;
            return 0;
        }
        return -1;
    }

    private ArrayList selectRegisterEvents() {
        ArrayList<String> arrayList = null;
        try {
            EventMapEditor eventMapEditor = new EventMapEditor();
            String string = eventMapEditor.getCurrentProject() + ".evt";
            arrayList = new ArrayList<String>();
            EventEditor eventEditor = new EventEditor();
            this.eventregArray = eventEditor.loadEventRegistryXML(string, (IFileEditorInput)this.eventMapScreen.getEditor().getEditorInput());
            for (int i = 0; i < this.eventregArray.length; ++i) {
                int n = this.eventExists(this.eventregArray[i]);
                if (n != -1) continue;
                arrayList.add(this.eventregArray[i].getProduct() + " /" + this.eventregArray[i].getProductInstance() + " /" + this.eventregArray[i].getObjectType() + " /" + this.eventregArray[i].getEventType());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private RegisteredEvent getEventRegistryObject(String[] stringArray) {
        if (this.eventregArray == null) {
            return null;
        }
        for (int i = 0; i < this.eventregArray.length; ++i) {
            if (!this.eventregArray[i].getEventType().equals(stringArray[3]) || !this.eventregArray[i].getObjectType().equals(stringArray[2]) || !this.eventregArray[i].getProduct().equals(stringArray[0]) || !this.eventregArray[i].getProductInstance().equals(stringArray[1])) continue;
            return this.eventregArray[i];
        }
        return null;
    }

    private ArrayList getSelectedEvents(ArrayList arrayList) {
        ArrayList<RegisteredEvent> arrayList2 = new ArrayList<RegisteredEvent>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            String[] stringArray = new String[4];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken().trim();
                ++n;
            }
            RegisteredEvent registeredEvent = this.getEventRegistryObject(stringArray);
            if (registeredEvent == null) continue;
            arrayList2.add(registeredEvent);
        }
        return arrayList2;
    }

    static /* synthetic */ String[] access$102(EventSelectionDialog eventSelectionDialog, String[] stringArray) {
        eventSelectionDialog.selectedItems = stringArray;
        return stringArray;
    }

    static /* synthetic */ String[] access$202(EventSelectionDialog eventSelectionDialog, String[] stringArray) {
        eventSelectionDialog.items = stringArray;
        return stringArray;
    }
}

