/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.eventmapeditor.wizards;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ALFNewWizardPage
extends WizardPage {
    private Text projectNameText;
    private ISelection selection;

    public ALFNewWizardPage(String string) {
        super("wizardPage");
        this.setTitle("Create ALF Project");
        this.setDescription("This wizard creates a new ALFProject files with *.evt *.svc files.");
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 9;
        Label label = new Label(composite2, 0);
        label.setText("&ProjectName:");
        this.projectNameText = new Text(composite2, 2052);
        GridData gridData = new GridData(768);
        this.projectNameText.setLayoutData((Object)gridData);
        this.projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ALFNewWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)composite2);
    }

    private void dialogChanged() {
        Object object;
        if (this.getContainerName().length() > 0) {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            object = iWorkspaceRoot.getProjects();
            for (int i = 0; i < ((IProject[])object).length; ++i) {
                if (!this.getContainerName().equalsIgnoreCase(object[i].getName())) continue;
                this.updateStatus("Project already exist.");
                return;
            }
        }
        if (this.getContainerName().length() > 120) {
            this.updateStatus("ALF Project Name should not exceed 120 characters.");
            return;
        }
        if (null != this.getContainerName() && this.getContainerName().trim().length() == 0) {
            this.updateStatus("File container must be specified.");
            return;
        }
        boolean bl = false;
        object = Pattern.compile("^[A-Za-z0-9\\s_-]+$");
        Matcher matcher = ((Pattern)object).matcher(this.getContainerName());
        bl = matcher.matches();
        if (!bl) {
            this.updateStatus(" Not a valid project name. Special characters not allowed.");
            return;
        }
        this.updateStatus(null);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.selection;
            if (iStructuredSelection.size() > 1) {
                return;
            }
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IResource) {
                IContainer iContainer = object instanceof IContainer ? (IContainer)object : ((IResource)object).getParent();
                this.projectNameText.setText(iContainer.getFullPath().toString());
            }
        }
    }

    private void updateStatus(String string) {
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }

    public String getContainerName() {
        return this.projectNameText.getText();
    }
}

