/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.crypto.impl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.crypto.CryptoProvider;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class ALFSSOCryptoProvider
implements CryptoProvider {
    static final Logger log = Logger.getLogger(ALFSSOCryptoProvider.class);
    protected String cryptoAlgorithm = null;
    protected Cipher encryptingCipher = null;
    protected Cipher decryptingCipher = null;
    protected SecretKey cipherKey = null;
    protected boolean cryptoEnabled = false;

    protected ALFSSOCryptoProvider() {
    }

    public ALFSSOCryptoProvider(String cryptoAlgorithm, String cryptoPassword) throws SSOException {
        this.initialize(cryptoAlgorithm, cryptoPassword);
    }

    protected Cipher createCipher(String cryptoAlgorithm) throws SSOException {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(cryptoAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            String errorMsg = "Failed to create cipher: No such algorithm:" + cryptoAlgorithm;
            log.error((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
        catch (NoSuchPaddingException e) {
            String errorMsg = "Failed to create cipher: No such padding";
            log.error((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
        return cipher;
    }

    protected SecretKey generateKey(String cryptoAlgorithm) throws SSOException {
        KeyGenerator kgen = null;
        try {
            log.debug((Object)"ALF SSO Crypto Provider: generating random secret");
            kgen = KeyGenerator.getInstance(cryptoAlgorithm);
            return kgen.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            String errorMsg = "Failed to generate key: No such algorithm:" + cryptoAlgorithm;
            log.error((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
    }

    protected SecretKey generateKey(String cryptoAlgorithm, String password) throws SSOException {
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray());
        try {
            SecretKeyFactory fac = SecretKeyFactory.getInstance(cryptoAlgorithm);
            return fac.generateSecret(pbeKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            String errorMsg = "Failed to generate key: No such algorithm:" + cryptoAlgorithm;
            log.error((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
        catch (InvalidKeySpecException e) {
            String errorMsg = "Failed to generate key: Invalid key spec";
            log.error((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
    }

    public void initialize(String cryptoAlgorithm, String cryptoPassword) throws SSOException {
        if (StringHelper.isBlank(cryptoAlgorithm)) {
            this.cryptoEnabled = false;
            return;
        }
        Cipher encryptingCipher = this.createCipher(cryptoAlgorithm);
        Cipher decryptingCipher = this.createCipher(cryptoAlgorithm);
        SecretKey cipherKey = null;
        cipherKey = StringHelper.isBlank(cryptoPassword) ? this.generateKey(cryptoAlgorithm) : this.generateKey(cryptoAlgorithm, cryptoPassword);
        try {
            encryptingCipher.init(1, cipherKey);
            decryptingCipher.init(2, cipherKey);
        }
        catch (InvalidKeyException e) {
            String errorMsg = "Faled to initialize cypher: Invalid key";
            log.error((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
        this.cryptoAlgorithm = cryptoAlgorithm;
        this.encryptingCipher = encryptingCipher;
        this.decryptingCipher = decryptingCipher;
        this.cipherKey = cipherKey;
        this.cryptoEnabled = true;
    }

    public byte[] encrypt(byte[] content) throws SSOException {
        if (!this.cryptoEnabled) {
            return content;
        }
        if (content == null) {
            return null;
        }
        byte[] encryptedContent = null;
        try {
            encryptedContent = this.encryptingCipher.doFinal(content);
        }
        catch (BadPaddingException e) {
            String errorMsg = "Error during encryption: bad padding";
            log.debug((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
        catch (IllegalBlockSizeException e) {
            String errorMsg = "Error during encryption: illegal block size";
            log.debug((Object)errorMsg, (Throwable)e);
            throw new SSOException(errorMsg, e);
        }
        return encryptedContent;
    }

    public byte[] decrypt(byte[] content) throws SSOException {
        if (!this.cryptoEnabled) {
            return content;
        }
        if (content == null) {
            return null;
        }
        byte[] decryptedContent = null;
        try {
            decryptedContent = this.decryptingCipher.doFinal(content);
        }
        catch (BadPaddingException e) {
            String errorMsg = "Error during decryption: bad padding";
            log.debug((Object)errorMsg, (Throwable)e);
            return null;
        }
        catch (IllegalBlockSizeException e) {
            String errorMsg = "Error during decryption: illegal block size";
            log.error((Object)errorMsg, (Throwable)e);
            return null;
        }
        return decryptedContent;
    }
}

