/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.servlet.ServletInputStream;

public class RewindableServletInputStream
extends ServletInputStream {
    private int readlimit = -1;
    private int mark = -1;
    private boolean closed = false;
    private int pos = -1;
    private int npos = -1;
    private byte[] readBuffer = null;

    public RewindableServletInputStream() {
        this.resetToEmptyStream();
    }

    public RewindableServletInputStream(byte[] source) {
        if (source != null) {
            this.readBuffer = source;
            this.pos = 0;
            this.npos = this.readBuffer.length;
        } else {
            this.resetToEmptyStream();
        }
    }

    public RewindableServletInputStream(String source) {
        this.resetToEmptyStream();
        if (source != null) {
            this.readBuffer = source.getBytes();
            this.pos = 0;
            this.npos = this.readBuffer.length;
        }
    }

    public RewindableServletInputStream(InputStream istream) throws IOException {
        byte[] buf;
        int nread;
        if (istream == null) {
            this.resetToEmptyStream();
            return;
        }
        ArrayList<byte[]> buffers = new ArrayList<byte[]>();
        ArrayList<Integer> bufsizes = new ArrayList<Integer>();
        int totalBytesRead = 0;
        while ((nread = istream.read(buf = new byte[65535])) != -1) {
            totalBytesRead += nread;
            buffers.add(buf);
            bufsizes.add(new Integer(nread));
            if (nread >= buf.length) continue;
            break;
        }
        if (totalBytesRead == 0) {
            this.readBuffer = new byte[0];
            this.pos = 0;
            this.npos = 0;
            return;
        }
        int curDestPos = 0;
        this.readBuffer = new byte[totalBytesRead];
        this.pos = 0;
        this.npos = this.readBuffer.length;
        for (int i = 0; i < buffers.size(); ++i) {
            byte[] buf2 = (byte[])buffers.get(i);
            int bufsize = (Integer)bufsizes.get(i);
            System.arraycopy(buf2, 0, this.readBuffer, curDestPos, curDestPos + bufsize);
            curDestPos += bufsize;
        }
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        int c;
        if (len <= 0) {
            return 0;
        }
        int count = 0;
        while ((c = this.read()) != -1) {
            b[off++] = (byte)c;
            if (c != 10 && ++count != len) continue;
        }
        return count > 0 ? count : -1;
    }

    public int available() throws IOException {
        if (this.pos < this.npos) {
            return this.npos - this.pos;
        }
        return 0;
    }

    public synchronized void close() {
        this.closed = true;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int readlimit) {
        this.readlimit = readlimit;
        this.mark = this.pos;
    }

    public synchronized void reset() throws IOException {
        if (this.mark == -1) {
            throw new IOException("Mark has not been set");
        }
        if (this.pos - this.mark > this.readlimit) {
            throw new IOException("Number of bytes read exceeds readlimit");
        }
        this.pos = this.mark;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            return 0L;
        }
        if ((long)this.pos + n > (long)this.npos) {
            long skipped = this.npos - this.pos;
            this.pos = this.npos;
            return skipped;
        }
        this.pos += (int)n;
        return n;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        int n = -1;
        n = this.npos - this.pos > len ? len : this.npos - this.pos;
        System.arraycopy(this.readBuffer, this.pos, b, off, n);
        this.pos += n;
        return n;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.pos < this.npos) {
            return this.readBuffer[this.pos++] & 0xFF;
        }
        return -1;
    }

    private void resetToEmptyStream() {
        this.readBuffer = new byte[0];
        this.pos = 0;
        this.npos = 0;
    }
}

