/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.crypto.CryptoProvider;
import org.eclipse.alf.security.sso.common.crypto.CryptoProviderFactory;
import org.eclipse.alf.security.sso.common.http.configuration.ConfigParameter;
import org.eclipse.alf.security.sso.common.http.configuration.ConfigParameterMap;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfigConstants;
import org.eclipse.alf.security.sso.common.http.configuration.PrincipalEndorsmentConfig;
import org.eclipse.alf.security.sso.common.http.configuration.builder.PrincipalEndorsmentConfigBuilder;
import org.eclipse.alf.security.sso.common.http.cookie.CookieManager;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProvider;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProviderRegistry;
import org.eclipse.alf.security.sso.common.util.FileIOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataClient;
import org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataClientImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustVersion;

public class CoreConfig {
    static final Logger log = Logger.getLogger(CoreConfig.class);
    public static final String SSO_CONFIG_FILE = "SSOConfigFile";
    public static final String SSOCONFIGFILE_LN = "ssoconfig";
    public static final String SSOCONFIGFILE_NAME_ATTR = "name";
    public static final String SSOCONFIGFILE_NAME_ATTR_EXPECTED_VALUE = "ALFSSO 1.0";
    public static final String SSO_CONFIG_FILE_DEFAULT = "/WEB-INF/conf/ssoconfig.xml";
    protected CookieManager cookieManager;
    protected ConfigParameterMap params;
    protected KeystoreProviderRegistry keystoreProviderRegistry;
    protected WSTrust wst;
    protected ArrayList allowedPreauthenticationTypes;
    protected RemoteDataClient remoteDataClient;
    protected HashMap substitutionVariables;

    public CoreConfig() {
        this.reset();
    }

    public void reset() {
        this.wst = new WSTrust(WSTrustVersion.V1);
        this.keystoreProviderRegistry = new KeystoreProviderRegistry();
        this.params = new ConfigParameterMap();
        this.substitutionVariables = new HashMap();
        this.remoteDataClient = new RemoteDataClientImpl();
    }

    public CookieManager initializeCookieManager() throws SSOException {
        this.cookieManager = new CookieManager();
        int maxCookieSize = this.getIntParameter("MaxCookieSize", 4096);
        this.cookieManager.setMaxCookieSize(maxCookieSize);
        int maxCookieChunks = this.getIntParameter("MaxCookieChunks", 5);
        this.cookieManager.setMaxCookieChunks(maxCookieChunks);
        boolean doNotPersistCookies = this.getBooleanParameter("PersistCookies", true);
        this.cookieManager.setPersistCookies(doNotPersistCookies);
        boolean bindCookiesToUserIP = this.getBooleanParameter("BindCookiesToUserIP", true);
        this.cookieManager.setBindCookiesToUserIP(bindCookiesToUserIP);
        log.debug((Object)("maxCookieSize=" + maxCookieSize + " maxCookieChunks=" + maxCookieChunks + " doNotPersistCookies=" + doNotPersistCookies + " bindCookiesToUserIP=" + bindCookiesToUserIP));
        String cookieEncryptionAlgorithm = this.getParameter("CookieEncryptionAlgorithm", "");
        log.debug((Object)("cookieEncryptionAlgorithm=" + cookieEncryptionAlgorithm));
        String cryptoPassword = this.getParameter("CookieEncryptionPassword", "");
        log.debug((Object)("cookieEncryptionPassword=" + (StringHelper.isBlank(cryptoPassword) ? "(random)" : "(from config)")));
        try {
            CryptoProvider cryptoProvider = CryptoProviderFactory.createALFSSOCryptoProvider(cookieEncryptionAlgorithm, cryptoPassword);
            this.cookieManager.setCryptoProvider(cryptoProvider);
        }
        catch (SSOException e) {
            log.error((Object)("Failed to initialize cookie crypto provider. cookieEncryptionAlgorithm:" + cookieEncryptionAlgorithm), (Throwable)e);
            throw new SSOException("Failed to initialize cookie crypto provider", e);
        }
        boolean compressCookies = this.getBooleanParameter("CookieCompression", true);
        this.cookieManager.setCompressCookies(compressCookies);
        return this.cookieManager;
    }

    public ConfigParameterMap getParameters() {
        return this.params;
    }

    public void setParameters(ConfigParameterMap newParams) {
        this.params = newParams;
    }

    public String getParameter(String key) {
        return this.getParameter(key, null);
    }

    public String getParameter(String key, String defaultValue) {
        ConfigParameter param = this.params.getParameter(key);
        if (param != null && param.getStringValue(null) != null) {
            return param.getStringValue();
        }
        return defaultValue;
    }

    public OMElement getOMElementParameter(String key, OMElement defaultValue) {
        OMElement retVal;
        ConfigParameter param = this.params.getParameter(key);
        if (param != null && (retVal = param.getOMElementValue(null)) != null) {
            return retVal;
        }
        return defaultValue;
    }

    public int getIntParameter(String key, int defaultValue) {
        ConfigParameter param = this.params.getParameter(key);
        if (param == null) {
            return defaultValue;
        }
        Integer retval = param.getIntValue(new Integer(defaultValue));
        if (retval == null) {
            return defaultValue;
        }
        return retval;
    }

    public long getLongParameter(String key, long defaultValue) {
        ConfigParameter param = this.params.getParameter(key);
        if (param == null) {
            return defaultValue;
        }
        Long retval = param.getLongValue(new Long(defaultValue));
        if (retval == null) {
            return defaultValue;
        }
        return retval;
    }

    public Boolean getBooleanParameter(String key) {
        return this.getBooleanParameter(key, null);
    }

    private Boolean getBooleanParameter(String key, Boolean defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("defaultValue cannot be null");
        }
        ConfigParameter param = this.params.getParameter(key);
        if (param == null) {
            return defaultValue;
        }
        return param.getBooleanValue(defaultValue);
    }

    public boolean getBooleanParameter(String key, boolean defaulValue) {
        Boolean retVal = this.getBooleanParameter(key, defaulValue ? Boolean.TRUE : Boolean.FALSE);
        return retVal;
    }

    public Object get(String key) {
        return this.params.getParameter(key);
    }

    public void setProperty(String key, String value) {
        ConfigParameter param = new ConfigParameter(key, value);
        this.params.addOrReplaceParameter(param);
    }

    public Iterator getAllParameters() {
        return this.params.getParametersMap().values().iterator();
    }

    public KeystoreProvider getKeystoreProvider(String keystoreName) {
        return this.keystoreProviderRegistry.getKeystoreProvider(keystoreName);
    }

    public void setKeystoreProviderRegistry(KeystoreProviderRegistry keystoreProviderRegistry) {
        this.keystoreProviderRegistry = keystoreProviderRegistry;
    }

    public KeystoreProviderRegistry getKeystoreProviderRegistry() {
        return this.keystoreProviderRegistry;
    }

    public void setKeystoreProvider(KeystoreProvider keystoreProvider) {
        this.keystoreProviderRegistry.addOrReplaceKeystoreProvider(keystoreProvider);
    }

    public WSTrust getDefaultWSTrust() {
        return this.wst;
    }

    public String getSTSEPR() {
        return this.getParameter("SecurityTokenService", "http://localhost/TokenService/services/Trust");
    }

    public synchronized RemoteDataClient instantiateRemoteDataClient() throws SSOException {
        String remoteDataClientClass = this.getParameter("RemoteDataClientClass", "org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataClientImpl");
        if (StringHelper.isBlank(remoteDataClientClass)) {
            log.error((Object)"Error creating remote data client class: no such class");
            return null;
        }
        ClassLoader cl = null;
        try {
            cl = this.getClass().getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
        }
        catch (SecurityException e) {
            log.error((Object)("Error creating remote data client class: security error:" + e.getMessage()));
            throw new SSOException("Error creating remote data client class: security error:" + e.getMessage(), e);
        }
        if (cl == null) {
            log.error((Object)"Error creating remote data client class: failed to create get a class loader");
            throw new SSOException("Error creating remote data client class: failed to create get a class loader");
        }
        Class<?> c = null;
        try {
            c = cl.loadClass(remoteDataClientClass);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Error creating remote data client class: class could not be found: " + remoteDataClientClass));
            throw new SSOException("Error creating remote data client class: class could not be found: " + remoteDataClientClass, e);
        }
        if (c == null) {
            log.error((Object)("Error creating remote data client class: class failed to load: " + remoteDataClientClass));
            throw new SSOException("Error creating remote data client class: class failed to load: " + remoteDataClientClass);
        }
        Object o = null;
        try {
            o = c.newInstance();
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Error creating remote data client class: failed to instantiate: " + remoteDataClientClass));
            throw new SSOException("Error creating remote data client class: failed to instantiate: " + remoteDataClientClass, e);
        }
        catch (InstantiationException e) {
            log.error((Object)("Error creating remote data client class: failed to instantiate: " + remoteDataClientClass));
            throw new SSOException("Error creating remote data client class: failed to instantiate: " + remoteDataClientClass, e);
        }
        catch (ExceptionInInitializerError e) {
            log.error((Object)("Error creating remote data client class: failed to instantiate: " + remoteDataClientClass));
            throw new SSOException("Error creating remote data client class: failed to instantiate: " + remoteDataClientClass, e);
        }
        catch (SecurityException e) {
            log.error((Object)("Error creating remote data client class: failed to instantiate: " + remoteDataClientClass));
            throw new SSOException("Error creating remote data client class: failed to instantiate: " + remoteDataClientClass, e);
        }
        catch (Throwable e) {
            log.error((Object)("Error creating remote data client class: failed to instantiate: " + remoteDataClientClass));
            throw new SSOException("Error creating remote data client class: failed to instantiate: " + remoteDataClientClass, e);
        }
        if (o == null) {
            log.error((Object)("Error creating remote data client class: failed to instantiate - null: " + remoteDataClientClass));
            throw new SSOException("Error creating remote data client class: failed to instantiate - null: " + remoteDataClientClass);
        }
        if (!(o instanceof RemoteDataClient)) {
            log.error((Object)("Error creating remote data client class: class \"" + remoteDataClientClass + "\" is not correct instance"));
            throw new SSOException("Error creating remote data client class: class \"" + remoteDataClientClass + "\" is not correct instance");
        }
        this.remoteDataClient = o;
        return this.remoteDataClient;
    }

    public RemoteDataClient getRemoteDataClient() {
        return this.remoteDataClient;
    }

    public String getRemoteDataURL(String originalURL, int serverPort) {
        Integer overwritePortInt;
        URL originalURLObj = null;
        log.debug((Object)("Creating URL for remote data access. originalURL=\"" + originalURL + "\", serverPort=" + serverPort));
        try {
            originalURLObj = new URL(originalURL);
        }
        catch (MalformedURLException e) {
            log.error((Object)("Remote Data URL creation failed - malformed URL: " + e.getMessage()));
            return originalURL;
        }
        if (originalURLObj == null) {
            return originalURL;
        }
        String overwriteProtocol = this.getParameter("RemoteDataRetrievalURLCreationProtocolOverwrite", "");
        String overwritePortString = this.getParameter("RemoteDataRetrievalURLCreationPortOverwrite", "");
        boolean forceServerPort = this.getBooleanParameter("RemoteDataRetrievalURLCreationForceServerPortInRemoteURL", false);
        String overwriteURI = this.getParameter("RemoteDataRetrievalURICreationURLOverwrite", "");
        int overwritePort = -1;
        if (StringHelper.isNotBlank(overwritePortString)) {
            try {
                overwritePortInt = new Integer(Integer.parseInt(overwritePortString));
                overwritePort = Integer.parseInt(overwritePortString);
                if (overwritePort < 1 && overwritePort > 65535) {
                    log.error((Object)("RemoteDataRetrieval URL preparation: overwrite port number is out of range: " + overwritePortString));
                    overwritePort = -1;
                    overwritePortString = "";
                }
                overwritePortString = overwritePortInt.toString();
                overwritePort = overwritePortInt;
                log.debug((Object)("RemoteDataRetrieval URL preparation: parsed and using overwrite port:" + overwritePortString));
            }
            catch (NumberFormatException e) {
                log.error((Object)("RemoteDataRetrieval URL preparation: error in parsing overwrite port number: " + overwritePortString));
                overwritePort = -1;
                overwritePortString = "";
            }
        }
        if (forceServerPort) {
            log.debug((Object)"RemoteDataRetrieval URL preparation: forcing server port in");
            if (serverPort > 0 && serverPort <= 65535) {
                overwritePortInt = new Integer(serverPort);
                overwritePortString = overwritePortInt.toString();
                overwritePort = serverPort;
                log.debug((Object)("RemoteDataRetrieval URL preparation:  using forced server port:" + overwritePortString));
            } else {
                log.error((Object)("RemoteDataRetrieval URL preparation: server port is invalid:" + serverPort));
            }
        }
        String overwriteHost = originalURLObj.getHost();
        boolean urlChanged = false;
        if (StringHelper.isBlank(overwriteProtocol)) {
            log.debug((Object)("RemoteDataRetrieval URL preparation: using original protocol: " + originalURLObj.getProtocol()));
            overwriteProtocol = originalURLObj.getProtocol();
        } else {
            log.debug((Object)("RemoteDataRetrieval URL preparation: using overwrite protocol: " + overwriteProtocol));
            urlChanged = true;
        }
        if (overwritePort == -1) {
            if (originalURLObj.getPort() == -1) {
                log.debug((Object)"RemoteDataRetrieval URL preparation: original URL doesn't contain a port in it and no overwrite defined. Resulting URL will not have port in it");
                overwritePortString = "";
                overwritePort = -1;
            } else {
                log.debug((Object)("RemoteDataRetrieval URL preparation: using original port: " + originalURLObj.getPort()));
                overwritePortString = new Integer(originalURLObj.getPort()).toString();
                overwritePort = originalURLObj.getPort();
            }
        } else {
            log.debug((Object)("RemoteDataRetrieval URL preparation: using overwrite port: " + overwritePortString));
            urlChanged = true;
        }
        if (StringHelper.isBlank(overwriteURI)) {
            log.debug((Object)("RemoteDataRetrieval URL preparation: using original URI: " + originalURLObj.getFile()));
            overwriteURI = originalURLObj.getFile();
        } else {
            log.debug((Object)("RemoteDataRetrieval URL preparation: using overwrite URI: " + overwriteURI));
            urlChanged = true;
        }
        if (!urlChanged) {
            log.debug((Object)"RemoteDataRetrieval URL preparation: no change required, returning original URL");
            return originalURLObj.toString();
        }
        String retVal = null;
        try {
            if (overwritePort >= 1 && overwritePort <= 65535) {
                URL resultURL = new URL(overwriteProtocol, overwriteHost, overwritePort, overwriteURI);
                retVal = resultURL.toString();
            } else {
                URL resultURL = new URL(overwriteProtocol, overwriteHost, overwriteURI);
                retVal = resultURL.toString();
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)("RemoteDataRetrieval URL preparation: caught MalformedURLException, returning original URL (" + originalURL + "): exception=" + e.getMessage()));
            retVal = originalURL;
        }
        log.debug((Object)("RemoteDataRetrieval URL preparation: Done transforming URL. Resulting URL: \"" + retVal + "\""));
        return retVal;
    }

    public Iterator getSupportedTokensList() {
        ArrayList<String> retVal = new ArrayList<String>();
        retVal.add("urn:oasis:names:tc:SAML:1.0:assertion#Assertion");
        return retVal.iterator();
    }

    protected void resolveAllowedPrinicpalAuthenticationTypes() {
        String param = this.getParameter("AllowedPrincipalAuthenticationTypes", "");
        StringTokenizer st = new StringTokenizer(param, ",");
        while (st.hasMoreTokens()) {
            this.allowedPreauthenticationTypes.add(st.nextToken());
        }
    }

    public boolean isAllowedPreauthenticationType(String authType) {
        if (this.allowedPreauthenticationTypes == null) {
            this.allowedPreauthenticationTypes = new ArrayList();
            this.resolveAllowedPrinicpalAuthenticationTypes();
        }
        if (authType == null || authType.trim().length() == 0) {
            return false;
        }
        return this.allowedPreauthenticationTypes.contains(authType);
    }

    public PrincipalEndorsmentConfig getPrincipalEndorsmentConfig() {
        OMElement paramEl = this.getOMElementParameter("PrincipalEndorsment", CoreConfigConstants.PRINCIPAL_ENDORSING_TOKEN_DEFAULT);
        PrincipalEndorsmentConfigBuilder builder = new PrincipalEndorsmentConfigBuilder();
        PrincipalEndorsmentConfig retVal = builder.build(paramEl);
        return retVal;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public String getAppBasePath() {
        return FileIOHelper.normalizePath(this.getParameter("ApplicationRootAbsolutePath"));
    }

    public String getConfBasePath() {
        return FileIOHelper.normalizePath(this.getParameter("ConfigBaseAbsolutePath"));
    }

    public void registerSubstitutionVariable(String variable, String name) {
        if (variable == null) {
            throw new IllegalArgumentException("variable argument cannot be null");
        }
        if (name == null) {
            name = "";
        }
        this.substitutionVariables.put(variable, name);
    }

    public void expandSubstitutionVariables() {
        Iterator paramKeyIt = this.params.parameters.keySet().iterator();
        if (paramKeyIt != null) {
            while (paramKeyIt.hasNext()) {
                String paramName = (String)paramKeyIt.next();
                ConfigParameter param = this.params.getParameter(paramName);
                if (param.getType() == 1) {
                    Iterator varsIt = this.substitutionVariables.keySet().iterator();
                    if (varsIt == null) continue;
                    while (varsIt.hasNext()) {
                        String varName = (String)varsIt.next();
                        String varValue = (String)this.substitutionVariables.get(varName);
                        if (param.getStringValue(paramName).indexOf(varName) == -1) continue;
                        String substitutedValue = StringHelper.simpleStringReplace(param.getStringValue(paramName), varName, varValue);
                        param.setValue(substitutedValue);
                    }
                    continue;
                }
                if (param.getType() != 2 || !log.isDebugEnabled()) continue;
                log.debug((Object)("Skipped expansion of substitution variables in parameter \"" + param.getName() + "\": " + "substitution in XML parameter values not yet supported"));
            }
        }
    }
}

