/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.builder;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.ConfigParameter;
import org.eclipse.alf.security.sso.common.http.configuration.ConfigParameterMap;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.configuration.builder.CoreConfigBuilder;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;

public class ConfigParameterMapBuilder {
    private static final Logger log = Logger.getLogger(ConfigParameterMapBuilder.class);
    public static final String CONFIG_PARAM_LN = "parameter";
    public static final String CONFIG_PARAM_NAME_ATTR = "name";
    protected String basePath = null;

    public ConfigParameterMapBuilder() {
    }

    public ConfigParameterMapBuilder(String basePath) {
        this.basePath = basePath;
    }

    public ConfigParameterMap build(OMElement el) {
        return this.build(el, null, true);
    }

    public ConfigParameterMap build(OMElement el, ConfigParameterMap baseParams) {
        return this.build(el, baseParams, true);
    }

    public ConfigParameterMap build(OMElement el, ConfigParameterMap baseParams, boolean loadIncludes) {
        ConfigParameterMap retVal = null;
        retVal = baseParams == null ? new ConfigParameterMap() : baseParams;
        Iterator iterator = el.getChildElements();
        if (iterator != null) {
            while (iterator.hasNext()) {
                String includeFilename;
                Iterator it;
                OMElement currentElement = (OMElement)iterator.next();
                if (currentElement.getLocalName().equals(CONFIG_PARAM_LN)) {
                    ConfigParameter parameter = new ConfigParameter();
                    parameter.setElement(currentElement);
                    String name = XMLHelper.getAttribute(currentElement, CONFIG_PARAM_NAME_ATTR);
                    if (StringHelper.isBlank(name)) continue;
                    parameter.setName(name.trim());
                    OMElement parameterValue = null;
                    it = currentElement.getChildElements();
                    if (it != null && it.hasNext()) {
                        parameterValue = (OMElement)it.next();
                    }
                    if (parameterValue != null) {
                        parameter.setValue(parameterValue);
                        parameter.setType(2);
                    } else {
                        String value = currentElement.getText();
                        parameter.setValue(value);
                        parameter.setType(1);
                    }
                    retVal.addOrReplaceParameter(parameter);
                    continue;
                }
                if (!loadIncludes || !currentElement.getLocalName().equals("include") || !StringHelper.isNotBlank(includeFilename = XMLHelper.getAttribute(currentElement, "file"))) continue;
                CoreConfigBuilder tempCoreConfigBuilder = new CoreConfigBuilder(this.basePath);
                tempCoreConfigBuilder.setLoadIncludedFiles(false);
                tempCoreConfigBuilder.setInitializeCookieManager(false);
                tempCoreConfigBuilder.setInstantiateRemoteDataClient(false);
                tempCoreConfigBuilder.setLoadKeystores(false);
                try {
                    CoreConfig tempCoreConfig = tempCoreConfigBuilder.build(includeFilename);
                    if (tempCoreConfig != null) {
                        it = tempCoreConfig.getAllParameters();
                        if (it == null) continue;
                        while (it.hasNext()) {
                            retVal.addOrReplaceParameter((ConfigParameter)it.next());
                        }
                        continue;
                    }
                    log.error((Object)("Failed to load include file: \"" + includeFilename + "\""));
                }
                catch (SSOException e) {
                    log.error((Object)("Failed to load sub-configuration: \"" + includeFilename + "\""));
                }
            }
        }
        return retVal;
    }
}

