/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.keystore;

import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProvider;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class KeystoreProviderRegistry {
    static final Logger log = Logger.getLogger(KeystoreProviderRegistry.class);
    private Hashtable keystores = new Hashtable();

    public KeystoreProviderRegistry() {
        this.reset();
    }

    public void reset() {
        this.keystores = new Hashtable();
    }

    public KeystoreProvider getKeystoreProvider(String keystoreName) {
        if (StringHelper.isBlank(keystoreName)) {
            return null;
        }
        return (KeystoreProvider)this.keystores.get(keystoreName);
    }

    public void addOrReplaceKeystoreProvider(KeystoreProvider keystoreProvider) {
        if (keystoreProvider != null) {
            KeystoreProvider existingKeystoreProvider = (KeystoreProvider)this.keystores.get(keystoreProvider.getId());
            if (existingKeystoreProvider != null) {
                if (existingKeystoreProvider.getKeystore() == null) {
                    log.debug((Object)"addOrReplaceKeystoreProvider: new keystoreProvider doesn't contain valid keystore. Replace skipped");
                } else {
                    this.keystores.put(keystoreProvider.getId(), keystoreProvider);
                    log.debug((Object)("addOrReplaceKeystoreProvider: Replacing keystore: " + keystoreProvider.getId()));
                }
            } else {
                this.keystores.put(keystoreProvider.getId(), keystoreProvider);
                log.debug((Object)("addOrReplaceKeystoreProvider: Adding new keystore to the registry: " + keystoreProvider.getId()));
            }
        }
    }

    public void addOrReplaceKeystoreRegistry(KeystoreProviderRegistry keystoreProviderRegistry) {
        Iterator it;
        if (keystoreProviderRegistry != null && keystoreProviderRegistry.keystores != null && (it = keystoreProviderRegistry.keystores.values().iterator()) != null) {
            while (it.hasNext()) {
                KeystoreProvider currentKeystoreProvider = (KeystoreProvider)it.next();
                this.addOrReplaceKeystoreProvider(currentKeystoreProvider);
            }
        }
    }
}

