/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.keystore.builder;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.SSOPasswordCallback;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProvider;
import org.eclipse.alf.security.sso.common.util.FileIOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;

public class KeystoreProviderBuilder {
    private static final Logger log = Logger.getLogger(KeystoreProviderBuilder.class);
    protected static final String KEYSTORE_LN = "KeyStore";
    protected static final String KEYSTORE_ID_ATTR = "id";
    protected static final String KEYSTORE_TYPE_ATTR = "type";
    protected static final String KEYSTORE_FILE_ATTR = "file";
    protected static final String KEYSTORE_PASSWORD_ATTR = "password";
    protected static final String KEYSTORE_PASSWORDPROP_ATTR = "passwordPropertyName";
    protected static final String KEYSTORE_PASSWORDCB_ATTR = "passwordCallback";
    protected String basePath;

    public KeystoreProviderBuilder() {
    }

    public KeystoreProviderBuilder(String basePath) {
        this.basePath = basePath;
    }

    public KeystoreProvider build(OMElement element) throws SSOException {
        return this.build(element, null);
    }

    public KeystoreProvider build(OMElement element, KeystoreProvider baseKeystoreProvider) throws SSOException {
        if (element == null) {
            throw new IllegalArgumentException("Element cannot be null");
        }
        OMElement keystoreElem = null;
        keystoreElem = element.getLocalName().equals(KEYSTORE_LN) ? element : element.getFirstChildWithName(new QName(KEYSTORE_LN));
        KeystoreProvider keystoreProvider = baseKeystoreProvider == null ? new KeystoreProvider() : baseKeystoreProvider;
        if (keystoreElem != null) {
            KeyStore ks;
            keystoreProvider.reset();
            String ksId = XMLHelper.getAttribute(keystoreElem, KEYSTORE_ID_ATTR);
            String ksType = XMLHelper.getAttribute(keystoreElem, KEYSTORE_TYPE_ATTR);
            String ksFile = XMLHelper.getAttribute(keystoreElem, KEYSTORE_FILE_ATTR);
            String ksPassword = XMLHelper.getAttribute(keystoreElem, KEYSTORE_PASSWORD_ATTR);
            String ksPasswordProp = XMLHelper.getAttribute(keystoreElem, KEYSTORE_PASSWORDPROP_ATTR);
            String ksPasswordCB = XMLHelper.getAttribute(keystoreElem, KEYSTORE_PASSWORDCB_ATTR);
            log.debug((Object)("Keystore load: processing keystore config element " + (StringHelper.isBlank(ksId) ? "with id=" + ksId : "default")));
            ksId = StringHelper.isBlank(ksId) ? "default" : ksId;
            keystoreProvider.setId(ksId);
            if (StringHelper.isBlank(ksType)) {
                keystoreProvider.setKeystoreType("JKS");
                log.debug((Object)"Using keystore type \"JKS\" (default)");
            } else {
                keystoreProvider.setKeystoreType(ksType);
                log.debug((Object)("Using keystore type \"" + ksType + "\""));
            }
            ksFile = FileIOHelper.resolveFilepath(this.basePath, ksFile);
            keystoreProvider.setKeystoreFile(ksFile);
            log.debug((Object)("Using keystore file \"" + ksFile + "\""));
            if (StringHelper.isNotBlank(ksPasswordCB)) {
                CallbackHandler cbHandler = null;
                ClassLoader classLoader = this.getClass().getClassLoader();
                log.debug((Object)("loading class : " + ksPasswordCB));
                try {
                    Class<?> cbClass = null;
                    cbClass = classLoader.loadClass(ksPasswordCB);
                    if (cbClass != null) {
                        cbHandler = (CallbackHandler)cbClass.newInstance();
                    }
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Failed to load class \"" + ksPasswordCB + "\" : class not found"));
                }
                catch (Exception e) {
                    log.error((Object)("Error while trying to load class \"" + ksPasswordCB + "\""), (Throwable)e);
                }
                Callback[] callbacks = new Callback[]{new SSOPasswordCallback(ksId, 1)};
                try {
                    cbHandler.handle(callbacks);
                }
                catch (IOException e) {
                    log.error((Object)"Failed to extract password from callback", (Throwable)e);
                }
                catch (UnsupportedCallbackException e) {
                    log.error((Object)"Unsupported callback exception was caught while handling keystore password callback", (Throwable)e);
                }
                String pass = ((SSOPasswordCallback)callbacks[0]).getPassword();
                if (pass != null) {
                    keystoreProvider.setKeystorePassword(pass);
                    log.debug((Object)("Set password returned from callback class \"" + ksPasswordCB + "\""));
                } else {
                    log.debug((Object)"Callback class did not return a valid password");
                }
            }
            if (StringHelper.isNotBlank(ksPasswordProp)) {
                try {
                    String pass = System.getProperty(ksPasswordProp);
                    if (pass != null) {
                        keystoreProvider.setKeystorePassword(pass);
                        log.debug((Object)"Password set from system property");
                    }
                }
                catch (SecurityException e) {
                    log.error((Object)"Security exception caught while trying to access system property");
                }
            }
            if (StringHelper.isBlank(keystoreProvider.getKeystorePassword())) {
                keystoreProvider.setKeystorePassword(ksPassword);
                log.debug((Object)"Password set from attribute");
            }
            if ((ks = this.loadKeystore(keystoreProvider.getKeystoreType(), keystoreProvider.getKeystoreFile(), keystoreProvider.getKeystorePassword())) == null) {
                String errMsg = "Failed to load keystore from \"" + keystoreProvider.getKeystoreFile() + "\"";
                log.error((Object)errMsg);
                throw new SSOException(errMsg);
            }
            keystoreProvider.setKeystore(ks);
        }
        return keystoreProvider;
    }

    private KeyStore loadKeystore(String keystoreType, String keystoreFile, String keystorePassword) throws SSOException {
        KeyStore retVal = null;
        try {
            retVal = KeyStore.getInstance(keystoreType);
        }
        catch (KeyStoreException e) {
            log.error((Object)"Error creating keystore instance", (Throwable)e);
            throw new SSOException("Error creating keystore instance");
        }
        InputStream is = FileIOHelper.loadResource(this.basePath, keystoreFile);
        if (is == null) {
            log.error((Object)("Error opening keystore file from \"" + keystoreFile + "\""));
            throw new SSOException("Error opening keystore file from \"" + keystoreFile + "\"");
        }
        try {
            retVal.load(is, keystorePassword.toCharArray());
        }
        catch (Exception e) {
            log.error((Object)("Error loading keystore data from \"" + keystoreFile + "\":"), (Throwable)e);
            throw new SSOException("Error loading keystore data from \"" + keystoreFile + "\":");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Keystore file from \"" + keystoreFile + "\" failed to close properly"));
            }
        }
        if (retVal == null) {
            log.error((Object)("Keystore file from \"" + keystoreFile + "\" failed to load properly"));
            throw new SSOException("Keystore file from \"" + keystoreFile + "\" failed to load properly");
        }
        return retVal;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
    }
}

