/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token;

import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.token.SSOClaim;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenPolicy;
import org.eclipse.alf.security.sso.common.token.impl.SSOClaimImpl;
import org.eclipse.alf.security.sso.common.token.impl.SSOTokenImpl;
import org.eclipse.alf.security.sso.common.token.saml.SAML1Handler;
import org.eclipse.alf.security.sso.common.token.saml.SAML1ObjectFactory;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.SAML1PolicyBuilder;
import org.eclipse.alf.security.sso.common.token.saml.policy.validator.SAML1PolicyValidatorImpl;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SignedSecurityToken;
import org.w3c.dom.Element;

public class SSOTokenFactory {
    private static Logger log = Logger.getLogger(SSOTokenFactory.class);
    private static final SAML1PolicyBuilder saml1PolicyBuilder = new SAML1PolicyBuilder();

    public static boolean isCompatibleNativeTokenType(String tokenTypeURI) {
        return SAML1ObjectFactory.isCompatibleTokenType(tokenTypeURI);
    }

    public static SSOToken createSSOToken(SecurityToken securityToken) throws SSOException {
        return SSOTokenFactory.createSSOToken(securityToken, null);
    }

    public static SSOToken createSSOToken(SecurityToken securityToken, SAML1Policy config) throws SSOException {
        if (!(securityToken instanceof SignedSecurityToken)) {
            throw new SSOException("Token not supported");
        }
        SAML1Handler samlHandler = SAML1ObjectFactory.createSAML1Handler(securityToken.getNativeObject());
        SAML1PolicyValidatorImpl samlValidator = SAML1ObjectFactory.createSAML1ProfileValidator();
        SSOTokenImpl token = new SSOTokenImpl(samlHandler, samlValidator, config);
        return token;
    }

    public static SSOToken createSSOToken(Element element) throws SSOException {
        return SSOTokenFactory.createSSOToken(element, null);
    }

    public static SSOToken createSSOToken(Element element, SAML1Policy config) throws SSOException {
        SAML1Handler samlHandler = SAML1ObjectFactory.createSAML1Handler(element);
        SAML1PolicyValidatorImpl samlValidator = SAML1ObjectFactory.createSAML1ProfileValidator();
        SSOTokenImpl token = new SSOTokenImpl(samlHandler, samlValidator, config);
        return token;
    }

    public static SSOToken createSSOToken(OMElement element) throws SSOException {
        return SSOTokenFactory.createSSOToken(element, null);
    }

    public static SSOToken createSSOToken(OMElement element, SAML1Policy config) throws SSOException {
        Element domEl = null;
        try {
            domEl = XMLHelper.toDOM(element);
        }
        catch (Exception e) {
            log.error((Object)"Error converting OM to DOM", (Throwable)e);
            throw new SSOException("Error converting OM to DOM");
        }
        if (domEl == null) {
            log.error((Object)"Error converting OM to DOM");
            throw new SSOException("Error converting OM to DOM");
        }
        return SSOTokenFactory.createSSOToken(domEl, config);
    }

    public static SSOToken createSSOToken(String tokenString) throws SSOException {
        return SSOTokenFactory.createSSOToken(tokenString, null);
    }

    public static SSOToken createSSOToken(String tokenString, SAML1Policy config) throws SSOException {
        Element domEl = null;
        try {
            OMElement omEl = XMLHelper.toOM(tokenString);
            domEl = XMLHelper.toDOM(omEl);
        }
        catch (Exception e) {
            log.error((Object)"Error converting String to DOM", (Throwable)e);
            throw new SSOException("Error converting String to DOM");
        }
        if (domEl == null) {
            log.error((Object)"Error converting String to DOM");
            throw new SSOException("Error converting String to DOM");
        }
        return SSOTokenFactory.createSSOToken(domEl, config);
    }

    public static SSOToken createSSOToken(Object object) throws SSOException {
        return SSOTokenFactory.createSSOToken(object, null);
    }

    public static SSOToken createSSOToken(Object object, SAML1Policy config) throws SSOException {
        SAML1Handler samlHandler = SAML1ObjectFactory.createSAML1Handler(object);
        SAML1PolicyValidatorImpl samlValidator = SAML1ObjectFactory.createSAML1ProfileValidator();
        SSOTokenImpl token = new SSOTokenImpl(samlHandler, samlValidator, config);
        return token;
    }

    public static SSOTokenPolicy createSSOTokenValidationPolicy() {
        return new SAML1Policy();
    }

    public static SSOTokenPolicy createSSOTokenValidationPolicy(OMElement element) throws SSOException {
        return saml1PolicyBuilder.build(element);
    }

    public static SSOTokenPolicy createSSOTokenValidationPolicy(String filename) throws SSOException {
        return saml1PolicyBuilder.build(filename);
    }

    public static SSOTokenPolicy createSSOTokenValidationPolicy(InputStream instream) throws SSOException {
        return saml1PolicyBuilder.build(instream);
    }

    public static SSOClaim createSSOClaim() {
        return new SSOClaimImpl();
    }

    public static SSOClaim createSSOClaim(QName claimName) {
        return new SSOClaimImpl(claimName);
    }

    public static SSOClaim createSSOClaim(QName claimName, Iterator claimValues) {
        return new SSOClaimImpl(claimName, claimValues);
    }

    public static SSOClaim createSSOClaim(QName claimName, String claimValue) {
        return new SSOClaimImpl(claimName, claimValue);
    }

    public static SSOClaim createSSOClaim(String name, String namespace, Iterator claimValues) {
        return new SSOClaimImpl(new QName(namespace, name), claimValues);
    }

    public static SSOClaim createSSOClaim(String name, String namespace, String claimValue) {
        return new SSOClaimImpl(new QName(namespace, name), claimValue);
    }
}

