/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.ClaimPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;

public class ClaimsPolicy
extends BasePolicy {
    private static final Logger log = Logger.getLogger(ClaimsPolicy.class);
    public static final boolean DEFAULT_ENFORCED = true;
    protected ArrayList claimPolicies;

    public ClaimsPolicy() {
    }

    public ClaimsPolicy(SAML1Policy contextPolicy) {
        super(contextPolicy);
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public void reset() {
        this.claimPolicies = new ArrayList();
    }

    public static boolean getIsEnforcedByDefault() {
        return true;
    }

    public Iterator getClaimPolicies() {
        return this.claimPolicies.iterator();
    }

    public void setClaimPolicies(Iterator claimPolicies) {
        this.claimPolicies = new ArrayList();
        if (claimPolicies != null) {
            while (claimPolicies.hasNext()) {
                Object next = claimPolicies.next();
                if (!(next instanceof ClaimPolicy)) continue;
                this.claimPolicies.add(next);
            }
        }
    }

    public void addClaimPolicy(ClaimPolicy claimPolicy) {
        Iterator it = this.claimPolicies.iterator();
        if (it != null) {
            while (it.hasNext()) {
                ClaimPolicy next = (ClaimPolicy)it.next();
                if (!next.equals(claimPolicy)) continue;
                it.remove();
            }
        }
        this.claimPolicies.add(claimPolicy);
    }
}

