/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy;

import java.security.KeyStore;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProvider;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProviderRegistry;
import org.eclipse.alf.security.sso.common.token.SSOTokenPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.AudienceRestrictionPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.AuthorityBindingPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.ClaimsPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.ExpirationPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.NameIdentifierPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SubjectConfirmationPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.TrustPolicy;

public class SAML1Policy
extends BasePolicy
implements SSOTokenPolicy {
    private static final Logger log = Logger.getLogger(SAML1Policy.class);
    protected AudienceRestrictionPolicy audienceRestrictionPolicy = null;
    protected AuthorityBindingPolicy authorityBindingPolicy = null;
    protected ClaimsPolicy claimsPolicy = null;
    protected ExpirationPolicy expirationPolicy = null;
    protected TrustPolicy trustPolicy = null;
    protected NameIdentifierPolicy nameIdentifierPolicy = null;
    protected SubjectConfirmationPolicy subjectConfirmationPolicy = null;
    protected KeystoreProviderRegistry keystoreProviderRegistry;
    protected String relyingPartyURI;
    protected String id;
    public static final String KEYSTORE_TYPE_DEFAULT = "JKS";
    public static final String KEYSTORE_LOCATION_DEFAULT = "";
    public static final String KEYSTORE_PASSWORD_DEFAULT = "";

    public SAML1Policy() {
        this.reset();
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public SAML1Policy(KeyStore keystore, String relyingPartyURI) {
        this.reset();
        KeystoreProvider keystoreProvider = new KeystoreProvider(keystore);
        this.keystoreProviderRegistry.addOrReplaceKeystoreProvider(keystoreProvider);
        this.relyingPartyURI = relyingPartyURI;
    }

    public void reset() {
        this.audienceRestrictionPolicy = new AudienceRestrictionPolicy(this);
        this.authorityBindingPolicy = new AuthorityBindingPolicy(this);
        this.claimsPolicy = new ClaimsPolicy(this);
        this.expirationPolicy = new ExpirationPolicy(this);
        this.trustPolicy = new TrustPolicy(this);
        this.nameIdentifierPolicy = new NameIdentifierPolicy(this);
        this.subjectConfirmationPolicy = new SubjectConfirmationPolicy(this);
        this.id = null;
        this.relyingPartyURI = RPURI.createRPURI().toString();
        this.keystoreProviderRegistry = new KeystoreProviderRegistry();
        this.keystoreProviderRegistry.addOrReplaceKeystoreProvider(new KeystoreProvider(KEYSTORE_TYPE_DEFAULT, "", ""));
    }

    public KeystoreProviderRegistry getKeystoreProviderRegistry() {
        return this.keystoreProviderRegistry;
    }

    public void setKeystoreProviderRegistry(KeystoreProviderRegistry keystoreProviderRegistry) {
        this.keystoreProviderRegistry = keystoreProviderRegistry;
    }

    public String getRelyingPartyURI() {
        return this.relyingPartyURI;
    }

    public void setRelyingPartyURI(String relyingPartyURI) {
        this.relyingPartyURI = relyingPartyURI;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AudienceRestrictionPolicy getAudienceRestrictionPolicy() {
        return this.audienceRestrictionPolicy;
    }

    public void setAudienceRestrictionPolicy(AudienceRestrictionPolicy audienceRestrictionPolicy) {
        this.audienceRestrictionPolicy = audienceRestrictionPolicy;
    }

    public AuthorityBindingPolicy getAuthorityBindingPolicy() {
        return this.authorityBindingPolicy;
    }

    public void setAuthorityBindingPolicy(AuthorityBindingPolicy authorityBindingPolicy) {
        this.authorityBindingPolicy = authorityBindingPolicy;
    }

    public ClaimsPolicy getClaimsPolicy() {
        return this.claimsPolicy;
    }

    public void setClaimsPolicy(ClaimsPolicy claimsPolicy) {
        this.claimsPolicy = claimsPolicy;
    }

    public ExpirationPolicy getExpirationPolicy() {
        return this.expirationPolicy;
    }

    public void setExpirationPolicy(ExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
    }

    public TrustPolicy getTrustPolicy() {
        return this.trustPolicy;
    }

    public void setTrustPolicy(TrustPolicy trustPolicy) {
        this.trustPolicy = trustPolicy;
    }

    public NameIdentifierPolicy getNameIdentifierPolicy() {
        return this.nameIdentifierPolicy;
    }

    public void setNameIdentifierPolicy(NameIdentifierPolicy nameIdentifierPolicy) {
        this.nameIdentifierPolicy = nameIdentifierPolicy;
    }

    public SubjectConfirmationPolicy getSubjectConfirmationPolicy() {
        return this.subjectConfirmationPolicy;
    }

    public void setSubjectConfirmationPolicy(SubjectConfirmationPolicy subjectConfirmationPolicy) {
        this.subjectConfirmationPolicy = subjectConfirmationPolicy;
    }
}

