/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.validator;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.token.SSOTokenValidationResult;
import org.eclipse.alf.security.sso.common.token.saml.SAML1Handler;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SubjectConfirmationPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.validator.BasePolicyValidator;

public class SubjectConfirmationPolicyValidator
extends BasePolicyValidator {
    private static final Logger log = Logger.getLogger(SubjectConfirmationPolicyValidator.class);

    /*
     * Enabled aggressive block sorting
     */
    public ExtendedResult validate(SAML1Handler samlHandler, BasePolicy policy) {
        SSOTokenValidationResult result;
        block7: {
            result = new SSOTokenValidationResult();
            SubjectConfirmationPolicy subjectConfirmationPolicy = (SubjectConfirmationPolicy)policy;
            if (subjectConfirmationPolicy.getAllowedConformationMethods().size() > 0) {
                Iterator it = samlHandler.getSubjectConfirmationMethods();
                if (it != null) {
                    while (it.hasNext()) {
                        String cm = (String)it.next();
                        if (subjectConfirmationPolicy.getAllowedConformationMethods().contains(cm)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Subject confirmation policy: missing token subject confirmations");
                        }
                        result.setCode(140);
                        return result;
                    }
                    break block7;
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Subject confirmation policy: missing token subject confirmations");
                    }
                    result.setCode(30);
                    return result;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Subject confirmation policy: no allowed subject confirmation methods. Assuming all allowed");
            }
        }
        result.setCode(0);
        return result;
    }
}

