/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.validator;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProvider;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProviderRegistry;
import org.eclipse.alf.security.sso.common.token.SSOTokenValidationResult;
import org.eclipse.alf.security.sso.common.token.saml.SAML1Handler;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.TrustPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.validator.BasePolicyValidator;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class TrustPolicyValidator
extends BasePolicyValidator {
    private static final Logger log = Logger.getLogger(TrustPolicyValidator.class);

    /*
     * Enabled aggressive block sorting
     */
    public ExtendedResult validate(SAML1Handler samlHandler, BasePolicy policy) {
        SSOTokenValidationResult result = new SSOTokenValidationResult();
        TrustPolicy trustPolicy = (TrustPolicy)policy;
        KeystoreProviderRegistry keystoreProviderRegistry = trustPolicy.getContextPolicy().getKeystoreProviderRegistry();
        if (trustPolicy != null) {
            String tokenSubject;
            List aliases;
            String tokenIssuer = samlHandler.getIssuer();
            if (StringHelper.isBlank(tokenIssuer)) {
                log.error((Object)"Trust policy validator: token missing issuer attribute");
                result.setCode(40);
                return result;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Validating issuer" + tokenIssuer));
            }
            if (!trustPolicy.getTrustedIssuerURIs().contains(tokenIssuer) && !trustPolicy.getTrustedIssuerURIs().contains("*")) {
                log.error((Object)("Issuer " + tokenIssuer + " is not on the trusted list"));
                result.setCode(40);
                return result;
            }
            if (trustPolicy.getTrustedIssuerCertificateAliases().size() > 0) {
                PublicKey pk = samlHandler.getSignaturePublicKey();
                if (pk != null) {
                    List aliases2 = trustPolicy.getTrustedIssuerCertificateAliases();
                    if (!this.validateSignaturePublicKey(keystoreProviderRegistry, aliases2, pk)) {
                        result.setCode(40);
                        return result;
                    }
                } else {
                    Iterator certIt = samlHandler.getSignatureCertificates();
                    aliases = trustPolicy.getTrustedIssuerCertificateAliases();
                    boolean trusted = false;
                    if (certIt == null) {
                        log.error((Object)"Trust policy validator: no signature crypto material can be found");
                        result.setCode(40);
                        return result;
                    }
                    while (certIt.hasNext()) {
                        Certificate cert = (Certificate)certIt.next();
                        if (!this.validateSignaturePublicKey(keystoreProviderRegistry, aliases, cert.getPublicKey())) continue;
                        trusted = true;
                        break;
                    }
                    if (!trusted) {
                        log.error((Object)"Trust policy validator: signature crypto matheria doesn't match any on the allowed list");
                        result.setCode(40);
                        return result;
                    }
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)"Trust policy validator: empty trusted issuer certificates list: no signature policy validation performed");
            }
            if (StringHelper.isBlank(tokenSubject = samlHandler.getNameIdentifier())) {
                log.error((Object)"Trust policy validator: token missing subject");
                result.setCode(170);
                return result;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Validating subject" + tokenSubject));
            }
            if (!trustPolicy.getTrustedSubjectNames().contains(tokenSubject) && !trustPolicy.getTrustedSubjectNames().contains("*")) {
                log.error((Object)("Subject name " + tokenSubject + " is not on the trusted list"));
                result.setCode(170);
                return result;
            }
            if (trustPolicy.getTrustedSubjectCertificateAliases().size() > 0) {
                PublicKey pk = samlHandler.getSubjectPublicKey();
                if (pk != null) {
                    aliases = trustPolicy.getTrustedSubjectCertificateAliases();
                    if (!this.validateSignaturePublicKey(keystoreProviderRegistry, aliases, pk)) {
                        result.setCode(170);
                        return result;
                    }
                } else {
                    X509Certificate cert = samlHandler.getSubjectX509Certificate();
                    List aliases3 = trustPolicy.getTrustedSubjectCertificateAliases();
                    if (cert == null) {
                        log.error((Object)"Trust policy validator: no subject crypto material can be found");
                        result.setCode(170);
                        return result;
                    }
                    if (!this.validateSignaturePublicKey(keystoreProviderRegistry, aliases3, cert.getPublicKey())) {
                        log.error((Object)"Trust policy validator: subject crypto material doesn't match any on the allowed list");
                        result.setCode(170);
                        return result;
                    }
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)"Trust policy validator: empty trusted subject certificates list: no signature policy validation performed");
            }
        }
        result.setCode(0);
        return result;
    }

    protected boolean validateSignaturePublicKey(KeystoreProviderRegistry keystoreProviderRegistry, List trustedCertificateAliases, PublicKey tokenSignaturePublicKey) {
        if (trustedCertificateAliases == null) {
            log.error((Object)"Trust policy validator: null list of trusted certificate aliases");
            return false;
        }
        if (tokenSignaturePublicKey == null) {
            log.error((Object)"Trust policy validator: null token public key");
            return false;
        }
        if (keystoreProviderRegistry == null) {
            log.error((Object)"Trust policy validator: null keystore");
            return false;
        }
        for (TrustPolicy.CertAlias alias : trustedCertificateAliases) {
            try {
                KeystoreProvider keystoreProvider = keystoreProviderRegistry.getKeystoreProvider(alias.getKeystoreId());
                KeyStore ks = null;
                if (keystoreProvider != null) {
                    ks = keystoreProvider.getKeystore();
                    if (ks == null) {
                        log.error((Object)("Trust policy validator: keystore provider does not have a matching keystore: " + alias.getKeystoreId()));
                        continue;
                    }
                } else {
                    log.error((Object)("Trust policy validator: failed to find keystore with name: " + alias.getKeystoreId()));
                    continue;
                }
                Certificate cert = ks.getCertificate(alias.getAlias());
                if (cert != null && cert.getPublicKey().equals(tokenSignaturePublicKey)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Trust policy validator: public key with alias \"" + alias + "\" matched successfully"));
                    }
                    return true;
                }
                Certificate[] certChain = ks.getCertificateChain(alias.getAlias());
                if (certChain == null) continue;
                for (int i = 0; i < certChain.length; ++i) {
                    cert = certChain[i];
                    if (cert == null || !cert.getPublicKey().equals(tokenSignaturePublicKey)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Trust policy validator: public key with alias \"" + alias + "\" matched successfully"));
                    }
                    return true;
                }
            }
            catch (KeyStoreException e) {
                log.error((Object)("Trust policy validator: exception while looking up alias \"" + alias + "\" from keystore"), (Throwable)e);
            }
        }
        return false;
    }
}

