/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenFactory;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.SOAPEngineConstants;

public class SOAPHelper {
    private static Logger log = Logger.getLogger(SOAPHelper.class);
    private static final String SAML_ASSERTATION_NS = "urn:oasis:names:tc:SAML:1.0:assertion";
    private static final String SAML_ASSERTION_LN = "Assertion";
    private static final QName SAML_ASSERTATION_QNAME = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");

    public static boolean isSOAPEnvelope(OMElement element) {
        if (element == null) {
            return false;
        }
        if (!element.getLocalName().equals("Envelope")) {
            return false;
        }
        OMNamespace ns = element.getNamespace();
        if (ns == null) {
            ns = element.getDefaultNamespace();
        }
        if (ns == null) {
            return false;
        }
        if (ns.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            return true;
        }
        return ns.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope");
    }

    public static SOAPEnvelope buildSOAPElement(String message) throws SSOException {
        try {
            StringReader stringReader = new StringReader(message);
            XMLStreamReader xmlr = XMLInputFactory.newInstance().createXMLStreamReader(stringReader);
            StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(xmlr, null);
            return (SOAPEnvelope)builder.getDocumentElement();
        }
        catch (SOAPProcessingException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Non-SOAP request processed");
            }
            return null;
        }
        catch (XMLStreamException e) {
            log.error((Object)"Unexpected exception caught while trying to build SOAP document:", (Throwable)e);
            throw new SSOException("Unexpected error while building SOAP document", e);
        }
        catch (OMException e) {
            log.error((Object)"Unexpected exception caught while trying to build SOAP document:", (Throwable)e);
            throw new SSOException("Unexpected error while building SOAP document", e);
        }
        catch (Exception e) {
            log.error((Object)"Unexpected exception caught while trying to build SOAP document:", (Throwable)e);
            throw new SSOException("Unexpected error while building SOAP document", e);
        }
    }

    public static SOAPEnvelope buildSOAPElement(InputStream inputStream) throws SSOException {
        try {
            XMLStreamReader xmlr = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(xmlr, null);
            return (SOAPEnvelope)builder.getDocumentElement();
        }
        catch (SOAPProcessingException e) {
            log.debug((Object)"Non-SOAP request processed");
            return null;
        }
        catch (XMLStreamException e) {
            log.error((Object)"Unexpected exception caught while trying to build SOAP document:", (Throwable)e);
            throw new SSOException("Unexpected error while building SOAP document", e);
        }
        catch (OMException e) {
            log.error((Object)"Unexpected exception caught while trying to build SOAP document:", (Throwable)e);
            throw new SSOException("Unexpected error while building SOAP document", e);
        }
        catch (Exception e) {
            log.error((Object)"Unexpected exception caught while trying to build SOAP document:", (Throwable)e);
            throw new SSOException("Unexpected error while building SOAP document", e);
        }
    }

    public static ArrayList extractWSSEHeaders(SOAPEnvelope soapEnvelope, String expectedActor) {
        if (soapEnvelope == null) {
            log.debug((Object)"Empty soap message passed in wsse header extraction routine");
            return null;
        }
        String ns = soapEnvelope.getNamespace().getNamespaceURI();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(ns)) {
            return SOAPHelper.getWSSEHeadersFromSOAP11(soapEnvelope, expectedActor);
        }
        return SOAPHelper.getWSSEHeadersFromSOAP12(soapEnvelope, expectedActor);
    }

    protected static ArrayList getWSSEHeadersFromSOAP11(SOAPEnvelope soapEnvelope, String expectedActor) {
        ArrayList<SOAPHeaderBlock> retVal = new ArrayList<SOAPHeaderBlock>();
        SOAPHeader soapHeader = soapEnvelope.getHeader();
        if (soapHeader == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Processed message with no header");
            }
            return null;
        }
        ArrayList wsseHeaders = soapHeader.getHeaderBlocksWithNSURI("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (wsseHeaders != null) {
            Iterator it = wsseHeaders.iterator();
            while (it != null && it.hasNext()) {
                SOAPHeaderBlock wsseHeader = (SOAPHeaderBlock)it.next();
                String soapActor = wsseHeader.getRole();
                if (StringHelper.isStringEqualExtendedIgnoreCase(soapActor, "http://schemas.xmlsoap.org/soap/actor/next")) {
                    retVal.add(wsseHeader);
                    continue;
                }
                if (!StringHelper.isStringEqualExtendedIgnoreCase(soapActor, expectedActor)) continue;
                retVal.add(wsseHeader);
            }
        }
        return retVal;
    }

    protected static ArrayList getWSSEHeadersFromSOAP12(SOAPEnvelope soapEnvelope, String expectedRole) {
        ArrayList<SOAPHeaderBlock> retVal = new ArrayList<SOAPHeaderBlock>();
        SOAPHeader soapHeader = soapEnvelope.getHeader();
        if (soapHeader == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Processed message with no header");
            }
            return null;
        }
        ArrayList wsseHeaders = soapHeader.getHeaderBlocksWithNSURI("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        Iterator it = wsseHeaders.iterator();
        if (it != null) {
            while (it.hasNext()) {
                SOAPHeaderBlock wsseHeader = (SOAPHeaderBlock)it.next();
                String soapRole = wsseHeader.getRole();
                if (StringHelper.isStringEqualExtendedIgnoreCase(soapRole, "http://www.w3.org/2003/05/soap-envelope/role/next")) {
                    retVal.add(wsseHeader);
                    continue;
                }
                if (StringHelper.isStringEqualExtendedIgnoreCase(soapRole, "http://www.w3.org/2003/05/soap-envelope/role/none") || StringHelper.isStringEqualExtendedIgnoreCase(soapRole, "http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver") || !StringHelper.isStringEqualExtendedIgnoreCase(soapRole, expectedRole)) continue;
                retVal.add(wsseHeader);
            }
        }
        return retVal;
    }

    public static SSOToken extractSSOTokenFromSOAPMessage(String soapMessage, String actor) {
        ByteArrayInputStream is = new ByteArrayInputStream(soapMessage.getBytes());
        SOAPEnvelope env = SOAPHelper.buildSOAPEnvelope(is);
        if (env == null) {
            return null;
        }
        return SOAPHelper.extractSSOTokenFromSOAPMessage(env, actor);
    }

    public static SSOToken extractSSOTokenFromSOAPMessage(SOAPEnvelope soapEnvelope, String actor) {
        ArrayList wsseHeaders = SOAPHelper.extractWSSEHeaders(soapEnvelope, actor);
        if (wsseHeaders == null || wsseHeaders.size() == 0) {
            log.warn((Object)("No security headers found for actor \"" + actor + "\""));
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracting security tokens from ALF SSO wsse security header (actor=\"" + actor + "\")"));
        }
        SSOToken ssotoken = null;
        ssotoken = SOAPHelper.extractSSOTokensFromWSSEHeader((SOAPHeaderBlock)wsseHeaders.get(0));
        if (ssotoken == null) {
            log.warn((Object)("No SSO tokens found in SOAP message security header for actor \"" + actor + "\""));
            return null;
        }
        return ssotoken;
    }

    public static SSOToken extractSSOTokensFromWSSEHeader(SOAPHeaderBlock wsseHeaderBlock) {
        OMElement el;
        SSOToken ssotoken = null;
        if (wsseHeaderBlock != null && (el = wsseHeaderBlock.getFirstChildWithName(SAML_ASSERTATION_QNAME)) != null) {
            try {
                ssotoken = SSOTokenFactory.createSSOToken(el);
            }
            catch (SSOException e) {
                log.error((Object)("Found element that is not understood:" + el.getLocalName()));
            }
        }
        return ssotoken;
    }

    public static boolean isSOAPRequestProfile(HttpServletRequest req) {
        int semicolon;
        if (!req.getMethod().equalsIgnoreCase("POST")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Non-SOAP request: not a HTTP/POST request");
            }
            return false;
        }
        String contentType = req.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        if (!(contentType = (semicolon = contentType.indexOf(59)) >= 0 ? contentType.substring(0, semicolon).trim() : contentType.trim()).equals("text/xml") && !contentType.equals("application/soap+xml")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Non-SOAP request: non-compatible content-type header");
            }
            return false;
        }
        return true;
    }

    public static SOAPEnvelope buildSOAPEnvelope(InputStream is) {
        try {
            SOAPEnvelope soapEnvelope = SOAPHelper.buildSOAPElement(is);
            if (soapEnvelope == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Non-SOAP request: failed to build SOAP envelope");
                }
                return null;
            }
            return soapEnvelope;
        }
        catch (IllegalStateException e) {
            log.error((Object)"Error building SOAP envelope from input stream", (Throwable)e);
            return null;
        }
        catch (SSOException e) {
            log.error((Object)"Error building SOAP envelope from input stream", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Error building SOAP envelope from input stream", (Throwable)e);
            return null;
        }
    }

    public static String extractSerializedSOAPMessage(OMElement response) {
        if (response == null) {
            log.error((Object)"Bad argument");
            throw new NullPointerException();
        }
        String decodedMessage = null;
        if (response.getQName().equals(SOAPEngineConstants.SOAP_SERIALIZATION_RESP_QNAME)) {
            String b64message = response.getText();
            decodedMessage = SSOHelper.B64Decode(b64message);
        }
        return decodedMessage;
    }

    public static SOAPEnvelope generateSOAPFault(SOAPEnvelope soapEnvelope, ExtendedResult validationResult, String faultActor) {
        if (soapEnvelope == null) {
            return null;
        }
        String ns = soapEnvelope.getNamespace().getNamespaceURI();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(ns)) {
            return SOAPHelper.generateSOAP11Fault(validationResult, faultActor);
        }
        return SOAPHelper.generateSOAP12Fault(validationResult, faultActor);
    }

    protected static SOAPEnvelope generateSOAP11Fault(ExtendedResult validationResult, String faultActor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering. faultActor=" + faultActor));
        }
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        SOAPFault fault = soapFactory.createSOAPFault(envelope.getBody());
        SOAPFaultCode code = soapFactory.createSOAPFaultCode(fault);
        String codeValueString1 = envelope.getNamespace().getPrefix() + ":" + "Server";
        String codeValueString2 = "wsse:FailedAuthentication";
        code.setText(codeValueString1 + "." + codeValueString2);
        SOAPFaultRole faultRole = soapFactory.createSOAPFaultRole(fault);
        faultRole.setText(faultActor);
        SOAPFaultReason faultReason = soapFactory.createSOAPFaultReason(fault);
        if (validationResult == null) {
            faultReason.setText("No compatible tokens found on the request");
        } else {
            faultReason.setText(validationResult.getMessage());
        }
        SOAPFaultDetail faultDetail = soapFactory.createSOAPFaultDetail(fault);
        if (validationResult == null) {
            faultDetail.setText("No compatible tokens found on the request");
        } else {
            faultDetail.setText(validationResult.getMessage());
        }
        return envelope;
    }

    protected static SOAPEnvelope generateSOAP12Fault(ExtendedResult validationResult, String faultActor) {
        return null;
    }

    public static void returnSOAPFault(HttpServletResponse resp, SOAPEnvelope fault) throws ServletException {
        if (fault == null) {
            return;
        }
        PrintWriter writer = null;
        try {
            writer = resp.getWriter();
        }
        catch (IOException e) {
            log.error((Object)"Cannot get response writer to return the SOAPFault", (Throwable)e);
            throw new ServletException("Cannot get response writer to return the SOAPFault", (Throwable)e);
        }
        writer.println(fault.toString());
    }
}

