/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.security.secext.element.impl;

import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSObject;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExt;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExtVersion;

public abstract class BaseWSSecExtObjectImpl
extends BaseWSObject
implements BaseWSInterface {
    static final Logger log = Logger.getLogger(BaseWSSecExtObjectImpl.class);

    public boolean baseIsCompatibleElement(OMElement element, String expectedLocalName) throws SSOException {
        throw new SSOException("This method should never be called");
    }

    public WSSecExt baseIsCompatibleElementSecExt(OMElement element, String expectedLocalName) throws SSOException {
        String localName = element.getLocalName();
        String wsseNSURI = element.getNamespace().getNamespaceURI();
        if (wsseNSURI == null || wsseNSURI.trim().length() == 0) {
            wsseNSURI = element.getDefaultNamespace().getNamespaceURI();
        }
        if (wsseNSURI == null || wsseNSURI.trim().length() == 0) {
            log.error((Object)("Could not determine namespace for <" + localName + ">"));
            throw new SSOException("Unknown wsse namespace");
        }
        if (!localName.equals(expectedLocalName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unknown element <" + localName + "> when expecting <" + expectedLocalName + ">"));
            }
            return null;
        }
        if (!WSSecExt.isSupportedNamespace(wsseNSURI)) {
            log.error((Object)("Unknown wsse namespace \"" + wsseNSURI + "\" in <" + expectedLocalName + "> found"));
            throw new SSOException("Unknown wsse namespace");
        }
        if (wsseNSURI.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) {
            return new WSSecExt(WSSecExtVersion.V10);
        }
        if (!wsseNSURI.equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) {
            return new WSSecExt(WSSecExtVersion.V11);
        }
        log.error((Object)("Unknown wst namespace \"" + wsseNSURI + "\" in <" + expectedLocalName + "> found"));
        throw new SSOException("Unknown wst namespace");
    }
}

