/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.security.secext.token.impl;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExt;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.impl.BaseWSSecExtObjectImpl;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SAML1Token;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML1TokenImpl
extends BaseWSSecExtObjectImpl
implements BaseWSInterface,
SAML1Token {
    private static final Logger log = Logger.getLogger(SAML1TokenImpl.class);
    protected WSSecExt wsse;
    protected SAMLAssertion samlAssertion;

    public SAML1TokenImpl() {
        this.reset();
        this.wsse = new WSSecExt();
        this.wsse.getVersion();
    }

    public SAML1TokenImpl(Object samlObject) {
        this.reset();
        this.wsse = new WSSecExt();
        this.samlAssertion = (SAMLAssertion)samlObject;
    }

    public SAML1TokenImpl(OMElement element) throws SSOException {
        this.reset();
        if (element == null) {
            return;
        }
        Element domEl = null;
        try {
            domEl = XMLHelper.toDOM(element);
        }
        catch (Exception e) {
            String errorMessage = "Error trying to convert element from OM to DOM";
            log.error((Object)errorMessage, (Throwable)e);
            throw new SSOException(errorMessage, e);
        }
        try {
            this.samlAssertion = new SAMLAssertion(domEl);
        }
        catch (SAMLException e) {
            String errorMessage = "Error trying to create SAML object";
            log.error((Object)errorMessage, (Throwable)e);
            throw new SSOException(errorMessage, e);
        }
        this.setParseSource(element);
    }

    public String getLocalName() {
        return "Assertion";
    }

    public void reset() {
        super.reset();
        this.samlAssertion = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof SAML1TokenImpl) {
            SAML1TokenImpl samlOneTokenImpl = (SAML1TokenImpl)other;
            try {
                this.samlAssertion = (SAMLAssertion)samlOneTokenImpl.samlAssertion.clone();
            }
            catch (CloneNotSupportedException e) {
                log.error((Object)("Error cloning SAML assertion: " + e.getMessage()), (Throwable)e);
                this.samlAssertion = samlOneTokenImpl.samlAssertion;
            }
        }
    }

    public String getType() {
        return "SAML1Token";
    }

    public String getIssuer() {
        if (this.samlAssertion != null) {
            return this.samlAssertion.getIssuer();
        }
        return null;
    }

    public String getId() {
        if (this.samlAssertion != null) {
            return this.samlAssertion.getId();
        }
        return null;
    }

    public boolean isSigned() {
        if (this.samlAssertion != null) {
            return this.samlAssertion.isSigned();
        }
        return false;
    }

    public final Object getNativeObject() {
        return this.samlAssertion;
    }

    public void setNativeObject(Object samlObject) {
        this.samlAssertion = (SAMLAssertion)samlObject;
        this.setDirty();
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        Node node = null;
        OMElement retVal = null;
        OMElement parentDoc = null;
        Document domDoc = null;
        if (parent != null && parent.getBuilder() != null) {
            parentDoc = parent.getBuilder().getDocumentElement();
            try {
                if (parentDoc != null) {
                    Element el = XMLHelper.toDOM(parentDoc);
                    domDoc = el.getOwnerDocument();
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception converting to DOM", (Throwable)e);
                return null;
            }
        }
        try {
            node = domDoc != null ? this.samlAssertion.toDOM(domDoc) : this.samlAssertion.toDOM();
        }
        catch (SAMLException e) {
            log.error((Object)"Exception convertion SAML assertion to DOM", (Throwable)e);
            return null;
        }
        try {
            retVal = XMLHelper.toOM((Element)node);
        }
        catch (Exception e) {
            log.error((Object)"Exception converting to Axis OM", (Throwable)e);
            return null;
        }
        parent.addChild((OMNode)retVal);
        return retVal;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        if (element == null) {
            return null;
        }
        Element domEl = null;
        try {
            domEl = XMLHelper.toDOM(element);
        }
        catch (Exception e) {
            log.error((Object)"Error while converting OM element to DOM element", (Throwable)e);
            return null;
        }
        try {
            this.samlAssertion = new SAMLAssertion(domEl);
        }
        catch (SAMLException e) {
            log.error((Object)"Error while creating SAML object from DOM element", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Unknown error while creating SAML object from DOM element", (Throwable)e);
            return null;
        }
        this.setParseSource(element);
        return this;
    }

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        if (element == null) {
            return false;
        }
        if (!element.getLocalName().equals("Assertion")) {
            return false;
        }
        String elementNSURI = element.getNamespace().getNamespaceURI();
        if (elementNSURI == null) {
            elementNSURI = element.getDefaultNamespace().getNamespaceURI();
        }
        if (elementNSURI == null) {
            return false;
        }
        if (elementNSURI.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
            return true;
        }
        return elementNSURI.equals("urn:oasis:names:tc:SAML:1.0:assertion");
    }

    public String toString() {
        if (!this.isParseSourceDirty()) {
            return this.getParseSource().toString();
        }
        if (this.samlAssertion != null) {
            return this.samlAssertion.toString();
        }
        return null;
    }
}

