/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.security.utility.element.impl;

import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSObject;

public abstract class BaseWSSecUtilitlyObjectImpl
extends BaseWSObject
implements BaseWSInterface {
    static final Logger log = Logger.getLogger(BaseWSSecUtilitlyObjectImpl.class);

    public boolean baseIsCompatibleElement(OMElement element, String expectedLocalName) throws SSOException {
        String localName = element.getLocalName();
        String wssuNSURI = element.getNamespace().getNamespaceURI();
        if (wssuNSURI == null || wssuNSURI.trim().length() == 0) {
            wssuNSURI = element.getDefaultNamespace().getNamespaceURI();
        }
        if (wssuNSURI == null || wssuNSURI.trim().length() == 0) {
            log.error((Object)("Could not determine namespace for <" + localName + ">"));
            throw new SSOException("Unknown wssu namespace");
        }
        if (!localName.equals(expectedLocalName)) {
            log.error((Object)("Unknown element <" + localName + "> when expecting <" + expectedLocalName + ">"));
            return false;
        }
        if (!wssuNSURI.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd")) {
            log.error((Object)("Unknown wssu namespace \"" + wssuNSURI + "\" in <" + expectedLocalName + "> found"));
            throw new SSOException("Unknown wssu namespace");
        }
        return true;
    }
}

