/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust.element.impl;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.EndpointReference;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.Issuer;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.BaseWSTrustObjectImpl;

public class IssuerImpl
extends BaseWSTrustObjectImpl
implements Issuer {
    private static final Logger log = Logger.getLogger(IssuerImpl.class);
    protected WSTrust wst;
    protected EndpointReference epr;

    private IssuerImpl() {
        this.reset();
        this.wst = new WSTrust();
    }

    public IssuerImpl(WSTrust wst) {
        this.reset();
        this.wst = wst;
    }

    public IssuerImpl(WSTrust wst, EndpointReference epr) {
        this.reset();
        this.wst = wst;
        this.epr = epr;
    }

    public String getLocalName() {
        return "Issuer";
    }

    public void reset() {
        super.reset();
        this.epr = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof IssuerImpl) {
            IssuerImpl otherIssuerImpl = (IssuerImpl)other;
            this.wst = otherIssuerImpl.wst;
            this.epr = otherIssuerImpl.epr;
        }
    }

    public EndpointReference getIssuer() {
        return this.epr;
    }

    public void setIssuer(EndpointReference epr) {
        this.epr = epr;
        this.setDirty();
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement issuerEl = this.wst.createOMElement(parent, this.getLocalName());
        this.epr.toOM(issuerEl);
        this.addAnyAttributesToElement(issuerEl);
        this.addAnyElementsToElementAsChildren(issuerEl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + issuerEl.toString() + "]"));
        }
        return issuerEl;
    }

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        return this.baseIsCompatibleElementTrust(element, this.getLocalName()) != null;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        throw new SSOException("Not implemented method");
    }

    public WSTrust getWSTrust() {
        return this.wst;
    }
}

