/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.axiom.om.OMElement;
import org.eclipse.alf.security.sso.common.http.configuration.ConfigParameter;
import org.eclipse.alf.security.sso.common.http.configuration.builder.ConfigParameterMapBuilder;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class ConfigParameterMap {
    protected HashMap parameters;

    public ConfigParameterMap() {
        this.reset();
    }

    public ConfigParameterMap(OMElement paramEl) {
        this.reset();
        ConfigParameterMapBuilder builder = new ConfigParameterMapBuilder();
        ConfigParameterMap paramMap = builder.build(paramEl);
        this.parameters = paramMap.getParametersMap();
    }

    public void reset() {
        this.parameters = new HashMap();
    }

    public void addParameter(ConfigParameter param) {
        if (param != null) {
            this.parameters.put(param.getName(), param);
        }
    }

    public void addOrReplaceParameter(String name, Object value) {
        if (StringHelper.isNotBlank(name) && value != null) {
            this.addOrReplaceParameter(new ConfigParameter(name, value));
        }
    }

    public void addOrReplaceParameter(ConfigParameter param) {
        if (param != null) {
            ConfigParameter oldParam = (ConfigParameter)this.parameters.get(param.getName());
            if (oldParam != null) {
                this.parameters.remove(param.getName());
            }
            this.parameters.put(param.getName(), param);
        }
    }

    public void removeParameter(ConfigParameter param) {
        this.parameters.remove(param.getName());
    }

    public ConfigParameter getParameter(String name) {
        return (ConfigParameter)this.parameters.get(name);
    }

    public ArrayList getParameters() {
        Collection col = this.parameters.values();
        ArrayList<ConfigParameter> para_list = new ArrayList<ConfigParameter>();
        for (ConfigParameter parameter : col) {
            para_list.add(parameter);
        }
        return para_list;
    }

    public HashMap getParametersMap() {
        return this.parameters;
    }
}

