/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.builder;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.configuration.builder.ConfigParameterMapBuilder;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProviderRegistry;
import org.eclipse.alf.security.sso.common.keystore.builder.KeystoreProviderRegistryBuilder;
import org.eclipse.alf.security.sso.common.util.FileIOHelper;

public class CoreConfigBuilder {
    private static final Logger log = Logger.getLogger(CoreConfigBuilder.class);
    public static final String SSOCONFIGFILE_LN = "CoreConfig";
    public static final String CONFIG_INCLUDE_LN = "include";
    public static final String CONFIG_INCLUDE_FILE_LN = "file";
    protected String basePath;
    protected boolean validateLocalName = true;
    protected boolean loadIncludedFiles = true;
    protected boolean loadKeystores = true;
    protected boolean initializeCookieManager = true;
    protected boolean instantiateRemoteDataClient = true;

    public CoreConfigBuilder() {
    }

    public CoreConfigBuilder(String basePath) {
        this.basePath = basePath;
    }

    protected boolean validateConfigElement(OMElement el) {
        String localname = SSOCONFIGFILE_LN;
        if (el.getLocalName().equals(localname)) {
            return true;
        }
        log.error((Object)("Error processing configuration file: <" + localname + "> not found, <" + el.getLocalName() + "> found instead"));
        return false;
    }

    public CoreConfig build(String configFilePath) throws SSOException {
        return this.build(configFilePath, null);
    }

    public CoreConfig build(String configFilePath, CoreConfig baseConfig) throws SSOException {
        InputStream is = FileIOHelper.loadResource(this.basePath, configFilePath);
        if (is == null) {
            log.error((Object)"Failed to load core config");
            return null;
        }
        CoreConfig retVal = null;
        try {
            retVal = this.build(is, baseConfig);
        }
        catch (SSOException e) {
            throw e;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)("Core config builder: error closing input stream: " + e.getMessage()));
                }
            }
        }
        return retVal;
    }

    public CoreConfig build(InputStream instream) throws SSOException {
        return this.build(instream, null);
    }

    public CoreConfig build(InputStream instream, CoreConfig baseConfig) throws SSOException {
        if (instream == null) {
            String errMsg = "Invalid input stream: null";
            log.error((Object)errMsg);
            throw new SSOException(errMsg);
        }
        StAXOMBuilder builder = null;
        try {
            builder = new StAXOMBuilder(instream);
        }
        catch (XMLStreamException e) {
            String errMsg = "Error obtaining StAXOMBuilder while trying to build config file object";
            log.error((Object)errMsg, (Throwable)e);
            throw new SSOException(errMsg, e);
        }
        if (builder == null) {
            String errMsg = "Failed to get a an StAXOMBuilder object: null";
            log.error((Object)errMsg);
            throw new SSOException(errMsg);
        }
        OMElement el = builder.getDocumentElement();
        if (el == null) {
            String errMsg = "The OM builder returned empty document";
            log.error((Object)errMsg);
            throw new SSOException(errMsg);
        }
        return this.build(el);
    }

    public CoreConfig build(OMElement el) throws SSOException {
        return this.build(el, null);
    }

    public CoreConfig build(OMElement el, CoreConfig baseConfig) throws SSOException {
        CoreConfig retVal = baseConfig;
        if (baseConfig == null) {
            retVal = new CoreConfig();
        }
        if (!this.validateConfigElement(el)) {
            log.error((Object)"Config file element validation failed");
            return null;
        }
        ConfigParameterMapBuilder configParamBuilder = new ConfigParameterMapBuilder(this.basePath);
        configParamBuilder.build(el, retVal.getParameters(), this.getLoadIncludedFiles());
        if (this.getLoadKeystores()) {
            try {
                KeystoreProviderRegistryBuilder ksRegistryBuilder = new KeystoreProviderRegistryBuilder(this.basePath);
                KeystoreProviderRegistry keystoreProviderRegistry = ksRegistryBuilder.build(el, retVal.getKeystoreProviderRegistry());
                retVal.setKeystoreProviderRegistry(keystoreProviderRegistry);
            }
            catch (SSOException e) {
                log.error((Object)"Error building/loading keystores", (Throwable)e);
                throw e;
            }
        }
        if (this.getInitializeCookieManager()) {
            retVal.initializeCookieManager();
        }
        if (this.getInstantiateRemoteDataClient()) {
            retVal.instantiateRemoteDataClient();
        }
        return retVal;
    }

    public boolean getValidateLocalName() {
        return this.validateLocalName;
    }

    public void setValidateLocalName(boolean validateLocalName) {
        this.validateLocalName = validateLocalName;
    }

    public boolean getLoadIncludedFiles() {
        return this.loadIncludedFiles;
    }

    public void setLoadIncludedFiles(boolean loadIncludedFiles) {
        this.loadIncludedFiles = loadIncludedFiles;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public boolean getInitializeCookieManager() {
        return this.initializeCookieManager;
    }

    public void setInitializeCookieManager(boolean initializeCookieManager) {
        this.initializeCookieManager = initializeCookieManager;
    }

    public boolean getLoadKeystores() {
        return this.loadKeystores;
    }

    public void setLoadKeystores(boolean loadKeystores) {
        this.loadKeystores = loadKeystores;
    }

    public boolean getInstantiateRemoteDataClient() {
        return this.instantiateRemoteDataClient;
    }

    public void setInstantiateRemoteDataClient(boolean instantiateRemoteDataClient) {
        this.instantiateRemoteDataClient = instantiateRemoteDataClient;
    }
}

