/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.keystore.builder;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.configuration.builder.CoreConfigBuilder;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProvider;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProviderRegistry;
import org.eclipse.alf.security.sso.common.keystore.builder.KeystoreProviderBuilder;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;

public class KeystoreProviderRegistryBuilder {
    private static final Logger log = Logger.getLogger(KeystoreProviderRegistryBuilder.class);
    protected static final String KEYSTORE_LN = "KeyStore";
    protected static final String KEYSTORE_ID_ATTR = "id";
    protected static final String KEYSTORE_TYPE_ATTR = "type";
    protected static final String KEYSTORE_FILE_ATTR = "file";
    protected static final String KEYSTORE_PASSWORD_ATTR = "password";
    protected static final String KEYSTORE_PASSWORDPROP_ATTR = "passwordPropertyName";
    protected static final String KEYSTORE_PASSWORDCB_ATTR = "passwordCallback";
    protected String basePath;
    protected boolean loadIncludedFiles = true;

    public KeystoreProviderRegistryBuilder() {
    }

    public KeystoreProviderRegistryBuilder(String basePath) {
        this.basePath = basePath;
    }

    public KeystoreProviderRegistry build(OMElement element) throws SSOException {
        return this.build(element, null);
    }

    public KeystoreProviderRegistry build(OMElement element, KeystoreProviderRegistry baseKeystoreProviderRegistry) throws SSOException {
        log.debug((Object)"Building keystore provider registry");
        if (element == null) {
            throw new IllegalArgumentException("Element cannot be null");
        }
        KeystoreProviderRegistry retVal = null;
        retVal = baseKeystoreProviderRegistry != null ? baseKeystoreProviderRegistry : new KeystoreProviderRegistry();
        KeystoreProviderBuilder builder = new KeystoreProviderBuilder(this.basePath);
        if (element.getLocalName().equals(KEYSTORE_LN)) {
            KeystoreProvider keystoreProvider = builder.build(element);
            if (keystoreProvider != null) {
                retVal.addOrReplaceKeystoreProvider(keystoreProvider);
            }
        } else {
            Iterator it = element.getChildrenWithName(new QName(KEYSTORE_LN));
            if (it != null) {
                while (it.hasNext()) {
                    OMElement keystoreElem = (OMElement)it.next();
                    KeystoreProvider keystoreProvider = builder.build(keystoreElem);
                    if (keystoreProvider == null) continue;
                    retVal.addOrReplaceKeystoreProvider(keystoreProvider);
                }
            }
            if (this.loadIncludedFiles && (it = element.getChildrenWithName(new QName("include"))) != null) {
                while (it.hasNext()) {
                    OMElement currentElement = (OMElement)it.next();
                    String includeFilename = XMLHelper.getAttribute(currentElement, KEYSTORE_FILE_ATTR);
                    if (!StringHelper.isNotBlank(includeFilename)) continue;
                    CoreConfigBuilder tempCoreConfigBuilder = new CoreConfigBuilder(this.basePath);
                    tempCoreConfigBuilder.setLoadIncludedFiles(false);
                    tempCoreConfigBuilder.setInitializeCookieManager(false);
                    tempCoreConfigBuilder.setInstantiateRemoteDataClient(false);
                    try {
                        CoreConfig tempCoreConfig = tempCoreConfigBuilder.build(includeFilename);
                        if (tempCoreConfig != null) {
                            KeystoreProviderRegistry keystoreProviderRegistry = tempCoreConfig.getKeystoreProviderRegistry();
                            retVal.addOrReplaceKeystoreRegistry(keystoreProviderRegistry);
                            continue;
                        }
                        log.error((Object)("Failed to load include file: \"" + includeFilename + "\""));
                    }
                    catch (SSOException e) {
                        log.error((Object)("Failed to load sub-configuration: \"" + includeFilename + "\""));
                    }
                }
            }
        }
        return retVal;
    }

    public void setLoadIncludedFiles(boolean loadIncludedFiles) {
        this.loadIncludedFiles = loadIncludedFiles;
    }
}

