/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.impl;

import java.security.PublicKey;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;

public class SAML1Helper {
    static final Logger log = Logger.getLogger(SAML1Helper.class);

    public static Iterator getCertificates(SAMLAssertion assertion) {
        if (assertion != null) {
            try {
                return assertion.getX509Certificates();
            }
            catch (SAMLException e) {
                log.info((Object)"Missing signature on SAML token");
                return null;
            }
        }
        return null;
    }

    public static PublicKey getPublicKeyFromSignature(SAMLAssertion assertion) {
        if (assertion != null) {
            try {
                if (assertion.getX509Certificates() != null) {
                    return null;
                }
            }
            catch (SAMLException e) {
                // empty catch block
            }
            Object sigObj = assertion.getNativeSignature();
            if (sigObj != null) {
                if (sigObj instanceof XMLSignature) {
                    XMLSignature sig = (XMLSignature)sigObj;
                    KeyInfo ki = sig.getKeyInfo();
                    if (ki != null) {
                        PublicKey pk = null;
                        try {
                            pk = ki.getPublicKey();
                        }
                        catch (KeyResolverException e) {
                            log.error((Object)"Error accesssing public key in SAML digital signature", (Throwable)e);
                            return null;
                        }
                        return pk;
                    }
                    log.error((Object)"Could not find key info in SAML signature");
                    return null;
                }
                log.error((Object)"Unknown digital signatrure manipulation object found on SAML object");
                return null;
            }
            log.error((Object)"No signature object found on SAML object");
            return null;
        }
        return null;
    }

    public static String getDigestAlgorithm(SAMLAssertion assertion) {
        if (assertion != null) {
            try {
                return assertion.getDigestAlgorithm();
            }
            catch (SAMLException e) {
                log.info((Object)"Missing signature on SAML token");
                return null;
            }
        }
        return null;
    }

    public static String getSignatureAlgorithm(SAMLAssertion assertion) {
        if (assertion != null) {
            try {
                return assertion.getSignatureAlgorithm();
            }
            catch (SAMLException e) {
                log.info((Object)"Missing signature on SAML token");
                return null;
            }
        }
        return null;
    }

    public static boolean compareSignatures(SAMLAssertion assertion1, SAMLAssertion assertion2) {
        if (assertion1 == null) {
            return false;
        }
        if (!assertion1.isSigned()) {
            return false;
        }
        if (assertion2 == null) {
            return false;
        }
        if (!assertion2.isSigned()) {
            return false;
        }
        Object sigObj1 = assertion1.getNativeSignature();
        Object sigObj2 = assertion2.getNativeSignature();
        XMLSignature sig1 = null;
        XMLSignature sig2 = null;
        if (sigObj1 != null && sigObj1 instanceof XMLSignature) {
            sig1 = (XMLSignature)sigObj1;
        }
        if (sigObj1 == null) {
            return false;
        }
        if (sigObj2 != null && sigObj2 instanceof XMLSignature) {
            sig2 = (XMLSignature)sigObj2;
        }
        if (sigObj2 == null) {
            return false;
        }
        byte[] sigValue1 = null;
        byte[] sigValue2 = null;
        try {
            sigValue1 = sig1.getSignatureValue();
            sigValue2 = sig2.getSignatureValue();
        }
        catch (XMLSignatureException e) {
            return false;
        }
        return sigValue1 == sigValue2;
    }
}

