/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.builder;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.token.SSOClaim;
import org.eclipse.alf.security.sso.common.token.SSOTokenFactory;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.ClaimPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.BasePolicyBuilder;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class ClaimPolicyBuilder
extends BasePolicyBuilder {
    private static final Logger log = Logger.getLogger(ClaimPolicyBuilder.class);
    public static final String CLAIM_POLICY_LN = "ClaimPolicy";
    public static final String ATTR_VALIDATE_LIFETIME_LN = "validateLifetime";
    public static final String ATTR_LIFETIME_LEEWAY_LN = "lifetimeLeeway";
    public static final String ATTR_MANDATORY_LN = "mandatory";
    public static final String ATTR_REQUESTABLE_FROM_STS_LN = "requestableFromSTS";
    public static final String CLAIM_NAME_LN = "Name";
    public static final String CLAIM_NAMESPACE_LN = "Namespace";
    public static final String CLAIM_ALLOWED_VALUES_LN = "AllowedValues";
    public static final String VALUE_LN = "Value";

    public String getLocalName() {
        return CLAIM_POLICY_LN;
    }

    public BasePolicy build(OMElement element) throws SSOException {
        return this.build(element, null);
    }

    public BasePolicy build(OMElement element, BasePolicy base) throws SSOException {
        if (element == null) {
            log.warn((Object)"ClaimPolicyBuilder.build(null) called");
            return base;
        }
        OMElement el = element;
        if (!el.getLocalName().equals(this.getLocalName())) {
            log.error((Object)("ClaimPolicyBuilder.build(): <" + el.getLocalName() + "> found when expecting <" + this.getLocalName() + ">"));
            return base;
        }
        ClaimPolicy claimPolicy = null;
        claimPolicy = base != null ? (ClaimPolicy)base : new ClaimPolicy();
        claimPolicy.setEnforced(SSOHelper.toBoolean(this.getAttribute(el, "enforce"), claimPolicy.getEnforced()));
        claimPolicy.setValidateLifetime(SSOHelper.toBoolean(this.getAttribute(el, ATTR_VALIDATE_LIFETIME_LN), claimPolicy.getValidateLifetime()));
        claimPolicy.setMandatory(SSOHelper.toBoolean(this.getAttribute(el, ATTR_MANDATORY_LN), claimPolicy.getMandatory()));
        claimPolicy.setRequestableFromSTS(SSOHelper.toBoolean(this.getAttribute(el, ATTR_REQUESTABLE_FROM_STS_LN), claimPolicy.getRequestableFromSTS()));
        String lifetimeLeewayString = this.getAttribute(el, ATTR_LIFETIME_LEEWAY_LN);
        if (StringHelper.isNotBlank(lifetimeLeewayString)) {
            try {
                Long lifetimeLeeway = new Long(lifetimeLeewayString);
                claimPolicy.setLifetimeLeeway(lifetimeLeeway);
            }
            catch (NumberFormatException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("@lifetimeLeeway attribute contains invalid setting: " + lifetimeLeewayString + " Default used: " + claimPolicy.getLifetimeLeeway()));
                }
                return null;
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("@lifetimeLeeway attribute doesn't have value. Default used: " + claimPolicy.getLifetimeLeeway()));
        }
        SSOClaim claim = SSOTokenFactory.createSSOClaim();
        OMElement claimNameEl = el.getFirstChildWithName(new QName(CLAIM_NAME_LN));
        if (claimNameEl != null) {
            String claimName = claimNameEl.getText();
            if (StringHelper.isNotBlank(claimName)) {
                claim.setName(claimName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsed <ClaimPolicy/Name> element: " + claimName));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Empty <ClaimPolicy/Name> element");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Missing <ClaimPolicy/Name> element");
        }
        OMElement claimNamespaceEl = el.getFirstChildWithName(new QName(CLAIM_NAMESPACE_LN));
        if (claimNamespaceEl != null) {
            String claimNamespace = claimNamespaceEl.getText();
            if (StringHelper.isNotBlank(claimNamespace)) {
                claim.setNamespace(claimNamespace);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsed <ClaimPolicy/Namespace> element: " + claimNamespace));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Empty <ClaimPolicy/Namespace> element");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Missing <ClaimPolicy/Namespace> element");
        }
        OMElement allowedValues = el.getFirstChildWithName(new QName(CLAIM_ALLOWED_VALUES_LN));
        if (allowedValues != null) {
            Iterator valuesIt = allowedValues.getChildrenWithName(new QName(VALUE_LN));
            if (valuesIt != null) {
                while (valuesIt.hasNext()) {
                    OMElement next = (OMElement)valuesIt.next();
                    String value = next.getText();
                    if (StringHelper.isNotBlank(value)) {
                        claim.addValue(value);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Empty <ClaimPolicy/AllowedValues/Value> element");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Missing <ClaimPolicy/AllowedValues/Value> elements");
            }
        }
        if (StringHelper.isBlank(claim.getName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invalid claim policy: missing name");
            }
            return null;
        }
        if (StringHelper.isBlank(claim.getNamespace())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invalid claim policy: missing namespace");
            }
            return null;
        }
        claimPolicy.setClaim(claim);
        return claimPolicy;
    }
}

