/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.builder;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.ExpirationPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.BasePolicyBuilder;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class ExpirationPolicyBuilder
extends BasePolicyBuilder {
    private static final Logger log = Logger.getLogger(ExpirationPolicyBuilder.class);
    public static final String EXPIRATION_POLICY_LN = "ExpirationPolicy";
    public static final String EXPIRATION_LEEWAY_LN = "ExpirationLeeway";

    public String getLocalName() {
        return EXPIRATION_POLICY_LN;
    }

    public BasePolicy build(OMElement element) throws SSOException {
        return this.build(element, null);
    }

    public BasePolicy build(OMElement element, BasePolicy basePolicy) throws SSOException {
        if (element == null) {
            log.warn((Object)"ExpirationPolicyBuilder.build(null) called");
            return basePolicy;
        }
        OMElement el = element.getFirstChildWithName(new QName(this.getLocalName()));
        if (el == null) {
            log.error((Object)"ExpirationPolicyBuilder.build(): policy local name not found");
            return basePolicy;
        }
        ExpirationPolicy expirationPolicy = null;
        expirationPolicy = basePolicy != null ? (ExpirationPolicy)basePolicy : new ExpirationPolicy();
        if (SSOHelper.toBoolean(this.getAttribute(el, "override"), expirationPolicy.getOverride())) {
            log.debug((Object)"ExpirationPolicyBuilder.build(): Overriding previously defined policy");
            expirationPolicy = new ExpirationPolicy();
        }
        expirationPolicy.setEnforced(SSOHelper.toBoolean(this.getAttribute(el, "enforce"), expirationPolicy.getEnforced()));
        OMElement expirationLeewayEl = el.getFirstChildWithName(new QName(EXPIRATION_LEEWAY_LN));
        if (expirationLeewayEl != null) {
            String value = expirationLeewayEl.getText();
            if (StringHelper.isNotBlank(value)) {
                try {
                    Long expirationLeeway = new Long(value);
                    expirationPolicy.setExpirationLeeway(expirationLeeway);
                }
                catch (NumberFormatException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("<ExpirationLeeway> element contains invalid setting: " + value + " Default used: " + expirationPolicy.getExpirationLeeway()));
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("<ExpirationLeeway> element doesn't have value. Default used: " + expirationPolicy.getExpirationLeeway()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("<ExpirationLeeway> element loaded: " + expirationPolicy.getExpirationLeeway()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("<ExpirationLeeway> element is missing, default used: " + expirationPolicy.getExpirationLeeway()));
        }
        return expirationPolicy;
    }
}

