/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.builder;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.keystore.KeystoreProviderRegistry;
import org.eclipse.alf.security.sso.common.keystore.builder.KeystoreProviderRegistryBuilder;
import org.eclipse.alf.security.sso.common.token.saml.policy.AudienceRestrictionPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.AuthorityBindingPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.ClaimsPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.ExpirationPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.NameIdentifierPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SubjectConfirmationPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.TrustPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.AudienceRestrictionPolicyBuilder;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.AuthorityBindingPolicyBuilder;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.BasePolicyBuilder;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.ClaimsPolicyBuilder;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.ExpirationPolicyBuilder;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.NameIdentifierPolicyBuilder;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.SubjectConfirmationPolicyBuilder;
import org.eclipse.alf.security.sso.common.token.saml.policy.builder.TrustPolicyBuilder;
import org.eclipse.alf.security.sso.common.util.FileIOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.UIDGenerator;

public class SAML1PolicyBuilder
extends BasePolicyBuilder {
    private static final Logger log = Logger.getLogger(SAML1PolicyBuilder.class);
    public static final String SSO_TOKEN_VALIDATION_POLICY_LN = "TokenPolicy";
    public static final String ATTR_ID_LN = "id";
    public static final String ATTR_INHERITS_FROM_LN = "inheritsFrom";
    protected static final AudienceRestrictionPolicyBuilder audienceRestrictionPolicyBuilder = new AudienceRestrictionPolicyBuilder();
    protected static final AuthorityBindingPolicyBuilder authorityBindingPolicyBuilder = new AuthorityBindingPolicyBuilder();
    protected static final ClaimsPolicyBuilder claimsPolicyBuilder = new ClaimsPolicyBuilder();
    protected static final ExpirationPolicyBuilder expirationPolicyBuilder = new ExpirationPolicyBuilder();
    protected static final TrustPolicyBuilder trustPolicyBuilder = new TrustPolicyBuilder();
    protected static final NameIdentifierPolicyBuilder nameIdentifierPolicyBuilder = new NameIdentifierPolicyBuilder();
    protected static final SubjectConfirmationPolicyBuilder subjectConfirmationPolicyBuilder = new SubjectConfirmationPolicyBuilder();
    String basePath = null;

    public SAML1PolicyBuilder() {
    }

    public SAML1PolicyBuilder(String basePath) {
        this.basePath = basePath;
    }

    public String getLocalName() {
        return SSO_TOKEN_VALIDATION_POLICY_LN;
    }

    public BasePolicy build(String configFilePath) throws SSOException {
        return this.build(configFilePath, null);
    }

    public BasePolicy build(String configFilePath, BasePolicy base) throws SSOException {
        InputStream is = FileIOHelper.loadResource(this.basePath, configFilePath);
        if (is == null) {
            String errMsg = "Error loading validation policy from \"" + configFilePath + "\" (basePath = \"" + this.basePath + "\")";
            log.error((Object)errMsg);
            return null;
        }
        BasePolicy retval = this.build(is, base);
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                String errMsg = "Error closing input stream";
                log.error((Object)errMsg);
            }
        }
        return retval;
    }

    public BasePolicy build(InputStream instream) throws SSOException {
        return this.build(instream, null);
    }

    public BasePolicy build(InputStream instream, BasePolicy base) throws SSOException {
        StAXOMBuilder builder = null;
        OMElement el = null;
        try {
            builder = new StAXOMBuilder(instream);
            el = builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            String errMsg = "Error loading validation policy from stream";
            log.error((Object)errMsg);
            throw new SSOException(errMsg, e);
        }
        return this.build(el, base);
    }

    public BasePolicy build(OMElement el) throws SSOException {
        return this.build(el, null);
    }

    public BasePolicy build(OMElement el, BasePolicy basePolicy) throws SSOException {
        SAML1Policy saml1Policy = null;
        saml1Policy = basePolicy != null ? (SAML1Policy)basePolicy : new SAML1Policy();
        saml1Policy.setId(this.getId(el, saml1Policy.getId()));
        KeystoreProviderRegistryBuilder ksBuilder = new KeystoreProviderRegistryBuilder();
        KeystoreProviderRegistry keystoreProviderRegistry = ksBuilder.build(el, saml1Policy.getKeystoreProviderRegistry());
        saml1Policy.setKeystoreProviderRegistry(keystoreProviderRegistry);
        AudienceRestrictionPolicy audienceRestrictionPolicy = (AudienceRestrictionPolicy)audienceRestrictionPolicyBuilder.build(el, saml1Policy.getAudienceRestrictionPolicy());
        saml1Policy.setAudienceRestrictionPolicy(audienceRestrictionPolicy);
        AuthorityBindingPolicy authorityBindingPolicy = (AuthorityBindingPolicy)authorityBindingPolicyBuilder.build(el, saml1Policy.getAuthorityBindingPolicy());
        saml1Policy.setAuthorityBindingPolicy(authorityBindingPolicy);
        ClaimsPolicy claimsPolicy = (ClaimsPolicy)claimsPolicyBuilder.build(el, saml1Policy.getClaimsPolicy());
        saml1Policy.setClaimsPolicy(claimsPolicy);
        ExpirationPolicy expirationPolicy = (ExpirationPolicy)expirationPolicyBuilder.build(el, saml1Policy.getExpirationPolicy());
        saml1Policy.setExpirationPolicy(expirationPolicy);
        TrustPolicy trustPolicy = (TrustPolicy)trustPolicyBuilder.build(el, saml1Policy.getTrustPolicy());
        saml1Policy.setTrustPolicy(trustPolicy);
        NameIdentifierPolicy nameIdentifierPolicy = (NameIdentifierPolicy)nameIdentifierPolicyBuilder.build(el, saml1Policy.getNameIdentifierPolicy());
        saml1Policy.setNameIdentifierPolicy(nameIdentifierPolicy);
        SubjectConfirmationPolicy subjectConfirmationPolicy = (SubjectConfirmationPolicy)subjectConfirmationPolicyBuilder.build(el, saml1Policy.getSubjectConfirmationPolicy());
        saml1Policy.setSubjectConfirmationPolicy(subjectConfirmationPolicy);
        return saml1Policy;
    }

    private String getId(OMElement el, String baseId) {
        String id = this.getAttribute(el, ATTR_ID_LN);
        if (StringHelper.isBlank(id)) {
            if (baseId == null) {
                id = UIDGenerator.getUUID();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SAML1 policy builder: empty @id> attribute. Using system generated id: " + id));
                }
                return id;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("SAML1 policy builder: using baseId for attribute @id attribute : " + baseId));
            }
            return baseId;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SAML1 policy builder: parsed @id attribute : " + id));
        }
        return id;
    }

    public String getInheritFrom(OMElement el) {
        return this.getAttribute(el, ATTR_INHERITS_FROM_LN);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}

