/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.validator;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.token.SSOClaim;
import org.eclipse.alf.security.sso.common.token.SSOTokenValidationResult;
import org.eclipse.alf.security.sso.common.token.saml.SAML1Attribute;
import org.eclipse.alf.security.sso.common.token.saml.SAML1Handler;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.ClaimPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.ClaimsPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.validator.BasePolicyValidator;

public class ClaimsPolicyValidator
extends BasePolicyValidator {
    private static final Logger log = Logger.getLogger(ClaimsPolicyValidator.class);

    /*
     * Enabled aggressive block sorting
     */
    public ExtendedResult validate(SAML1Handler samlHandler, BasePolicy policy) {
        SSOTokenValidationResult result;
        block13: {
            Iterator claimPoliciesIt;
            ArrayList<SSOClaim> requestableClaims;
            block14: {
                result = new SSOTokenValidationResult();
                ClaimsPolicy claimsPolicy = (ClaimsPolicy)policy;
                requestableClaims = new ArrayList<SSOClaim>();
                if (claimsPolicy == null) break block13;
                claimPoliciesIt = claimsPolicy.getClaimPolicies();
                if (claimPoliciesIt != null) break block14;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Claims policy matching: no claim policies defined");
                }
                break block13;
            }
            while (claimPoliciesIt.hasNext()) {
                ClaimPolicy claimPolicy;
                block15: {
                    SAML1Attribute attr;
                    block17: {
                        block16: {
                            claimPolicy = (ClaimPolicy)claimPoliciesIt.next();
                            if (!claimPolicy.getEnforced()) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)("Claims policy matching: claim \"" + claimPolicy.getClaim().getName() + "\" is not enforced. Skipping"));
                                continue;
                            }
                            attr = samlHandler.getAttribute(claimPolicy.getClaim().getName(), claimPolicy.getClaim().getNamespace());
                            if (attr == null) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Claims policy matching: claim \"" + claimPolicy.getClaim().getName() + "\" not found on token"));
                                }
                                if (!claimPolicy.getMandatory()) continue;
                                requestableClaims.add(claimPolicy.getClaim());
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)("Claims policy matching: claim \"" + claimPolicy.getClaim().getName() + "\" not found on token, but its requestable"));
                                continue;
                            }
                            if (attr.getLifetime() <= 0L) break block15;
                            if (!claimPolicy.getValidateLifetime()) break block16;
                            long issueInstantInSec = samlHandler.getIssueInstant().getTime() / 1000L;
                            long expTimeInSec = issueInstantInSec + attr.getLifetime();
                            long nowInSecPlusLeeway = System.currentTimeMillis() / 1000L + claimPolicy.getLifetimeLeeway();
                            if (nowInSecPlusLeeway <= expTimeInSec) break block17;
                            if (claimPolicy.getMandatory()) {
                                requestableClaims.add(claimPolicy.getClaim());
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Claims policy matching: claim \"" + claimPolicy.getClaim().getName() + "\" is expired but re-requestable"));
                                }
                                break block17;
                            } else {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Claims policy matching: claim \"" + claimPolicy.getClaim().getName() + "\": " + "attribute lifetime expired (" + expTimeInSec + "," + nowInSecPlusLeeway + ")"));
                                }
                                result.setCode(130);
                                requestableClaims.clear();
                                requestableClaims.add(claimPolicy.getClaim());
                                result.setMessageParams(requestableClaims.toArray());
                                return result;
                            }
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Claims policy matching: claim \"" + claimPolicy.getClaim().getName() + "\": lifetime validation skipped"));
                        }
                    }
                    if (claimPolicy.getClaim().getValue().equals("*") || claimPolicy.getClaim().getValues() == null) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Claims policy matching: claim \"" + claimPolicy.getClaim().getName() + "\": all values allowed"));
                        continue;
                    }
                    Iterator policyValuesIt = claimPolicy.getClaim().getValues();
                    boolean found = false;
                    while (policyValuesIt.hasNext()) {
                        String next = (String)policyValuesIt.next();
                        if (!attr.hasValue(next)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Claims policy matching: claim \"" + claimPolicy.getClaim().getName() + "\": " + "claim value policy violation"));
                    }
                    result.setCode(120);
                    return result;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Claims policy matching: claim \"" + claimPolicy.getClaim().getName() + "\": lifetime infinite"));
            }
        }
        result.setCode(0);
        return result;
    }
}

