/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.message.soapengine;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.TransportSender;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.util.SOAPHelper;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.RSTCallProxy;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.transport.SerializingTransportSender;
import org.eclipse.alf.security.sso.common.ws.message.trust.RSTRequest;

public class RSTSerializer
extends RSTCallProxy {
    private static final Logger log = Logger.getLogger(RSTSerializer.class);

    public RSTSerializer(String axis2repo, String axis2xml) throws SSOException {
        super(axis2repo, axis2xml);
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    protected void initialize(String path, String axis2xml) throws SSOException {
        super.initialize(path, axis2xml);
        TransportOutDescription tOut = new TransportOutDescription("serialization");
        tOut.setSender((TransportSender)new SerializingTransportSender());
        this.options.setTransportOut(tOut);
    }

    public String createSOAPMessage(RSTRequest request) throws SSOException {
        OMElement result = null;
        try {
            result = this.internalRSTInvoke(request);
        }
        catch (AxisFault e) {
            throw new SSOException("Error serializing a request: " + e.getMessage(), e);
        }
        return SOAPHelper.extractSerializedSOAPMessage(result);
    }
}

