/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.log4j.Logger;
import org.apache.rampart.handler.config.InflowConfiguration;
import org.apache.rampart.handler.config.OutflowConfiguration;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExt;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExtVersion;

public abstract class SecurityContext {
    static final Logger log = Logger.getLogger(SecurityContext.class);
    protected String ofcUsername = null;
    protected String ofcPassword = null;
    protected CallbackHandler ofcPasswordCallbackHandler = null;
    protected Hashtable headers = new Hashtable();
    protected String actor = null;
    protected OutflowConfiguration ofc = null;
    protected InflowConfiguration ifc = null;
    protected Map optionProperties = new HashMap();

    public SecurityContext() {
        this.ofc = new OutflowConfiguration();
        this.ifc = new InflowConfiguration();
    }

    public SecurityContext(OutflowConfiguration ofc, InflowConfiguration ifc) {
        this.ofc = ofc;
        this.ifc = ifc;
    }

    public InflowConfiguration getIfc() {
        return this.ifc;
    }

    public void setIfc(InflowConfiguration ifc) {
        this.ifc = ifc;
    }

    public OutflowConfiguration getOfc() {
        return this.ofc;
    }

    public void setOfc(OutflowConfiguration ofc) {
        this.ofc = ofc;
    }

    public Map getOptionProperties() {
        return this.optionProperties;
    }

    public String getOfcUsername() {
        return this.ofcUsername;
    }

    public void setOfcUsername(String ofcUsername) {
        this.ofcUsername = ofcUsername;
    }

    public String getOfcPassword() {
        return this.ofcPassword;
    }

    public void setOfcPassword(String ofcPassword) {
        this.ofcPassword = ofcPassword;
    }

    public String getActor() {
        return this.actor;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public void addElementToSecurityHeader(OMElement element, String actor) {
        ArrayList<OMElement> securityTokenList = null;
        String _actor = actor == null ? "" : actor;
        securityTokenList = (ArrayList<OMElement>)this.headers.get(_actor);
        if (securityTokenList == null) {
            securityTokenList = new ArrayList<OMElement>();
            this.headers.put(_actor, securityTokenList);
        }
        securityTokenList.add(element);
    }

    public SOAPHeaderBlock getSecurityHeaderAsOM(String actor) {
        ArrayList securityTokenList = null;
        String _actor = actor == null ? "" : actor;
        securityTokenList = (ArrayList)this.headers.get(_actor);
        if (securityTokenList == null) {
            securityTokenList = new ArrayList();
            this.headers.put(_actor, securityTokenList);
        }
        if (securityTokenList.size() > 0) {
            OMNamespace wsseNS = WSSecExt.getNamespace(WSSecExtVersion.V10);
            SOAPFactory fac = OMAbstractFactory.getSOAP11Factory();
            SOAPEnvelope envelope = fac.getDefaultEnvelope();
            SOAPHeaderBlock wsseSoapHeaderBlock = envelope.getHeader().addHeaderBlock("Security", wsseNS);
            for (OMElement current : securityTokenList) {
                wsseSoapHeaderBlock.addChild((OMNode)current);
            }
            wsseSoapHeaderBlock.setMustUnderstand(true);
            if (StringHelper.isNotBlank(_actor)) {
                wsseSoapHeaderBlock.setRole(_actor);
            }
            return wsseSoapHeaderBlock;
        }
        return null;
    }

    public ArrayList getSecurityHeadersListAsOM() {
        ArrayList<SOAPHeaderBlock> retVal = new ArrayList<SOAPHeaderBlock>();
        Enumeration en = this.headers.keys();
        if (en == null) {
            return retVal;
        }
        while (en.hasMoreElements()) {
            String _actor = (String)en.nextElement();
            SOAPHeaderBlock header = this.getSecurityHeaderAsOM(_actor);
            retVal.add(header);
        }
        return retVal;
    }
}

