/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.addressing.element.impl;

import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSObject;

public abstract class BaseWSAddressingObjectImpl
extends BaseWSObject
implements BaseWSInterface {
    static final Logger log = Logger.getLogger(BaseWSAddressingObjectImpl.class);

    public boolean baseIsCompatibleElement(OMElement element, String expectedLocalName) throws SSOException {
        String localName = element.getLocalName();
        String wsaNSURI = element.getNamespace().getNamespaceURI();
        if (wsaNSURI == null || wsaNSURI.trim().length() == 0) {
            wsaNSURI = element.getDefaultNamespace().getNamespaceURI();
        }
        if (wsaNSURI == null || wsaNSURI.trim().length() == 0) {
            log.error((Object)("Could not determine namespace for <" + localName + ">"));
            throw new SSOException("Unknown wsa namespace");
        }
        if (!localName.equals(expectedLocalName)) {
            log.error((Object)("Unknown element <" + localName + "> when expecting <" + expectedLocalName + ">"));
            return false;
        }
        if (!wsaNSURI.equals("http://www.w3.org/2005/08/addressing")) {
            log.error((Object)("Unknown wsa namespace \"" + wsaNSURI + "\" in <" + expectedLocalName + "> found"));
            throw new SSOException("Unknown wsa namespace");
        }
        return true;
    }
}

