/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.addressing.element.impl;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.addressing.WSAddressing;
import org.eclipse.alf.security.sso.common.ws.model.addressing.WSAddressingObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.Address;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.EndpointReference;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.impl.BaseWSAddressingObjectImpl;

public class EndpointReferenceImpl
extends BaseWSAddressingObjectImpl
implements EndpointReference {
    private static final Logger log = Logger.getLogger(EndpointReferenceImpl.class);
    protected Address address;

    public EndpointReferenceImpl() {
        this.reset();
    }

    public EndpointReferenceImpl(Address address) {
        this.reset();
        this.address = address;
    }

    public String getLocalName() {
        return "EndpointReference";
    }

    public void reset() {
        super.reset();
        this.address = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof EndpointReferenceImpl) {
            EndpointReferenceImpl otherEndpointReferenceImpl = (EndpointReferenceImpl)other;
            this.address = otherEndpointReferenceImpl.address;
        }
    }

    public void setAddress(Address address) {
        this.address = address;
        this.setDirty();
    }

    public Address getAddress() {
        return this.address;
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement eprEl = WSAddressing.createOMElement(parent, this.getLocalName());
        if (this.address != null) {
            this.address.toOM(eprEl);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + eprEl.toString() + "]"));
        }
        this.addAnyAttributesToElement(eprEl);
        this.addAnyElementsToElementAsChildren(eprEl);
        return eprEl;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        if (!this.isCompatibleElement(element)) {
            return null;
        }
        EndpointReferenceImpl epr = new EndpointReferenceImpl();
        Iterator it = element.getChildElements();
        if (it != null) {
            while (it.hasNext()) {
                OMElement workEl = (OMElement)it.next();
                String localName = workEl.getLocalName();
                if ("Address".equals(localName)) {
                    epr.address = WSAddressingObjectBuilder.buildAddress(workEl);
                    continue;
                }
                epr._anyElement.add(workEl.cloneOMElement());
            }
        }
        epr.setParseSource(element);
        this.copyFrom(epr);
        return this;
    }
}

