/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.policy.element.impl;

import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSObject;

public abstract class BaseWSPolicyObjectImpl
extends BaseWSObject
implements BaseWSInterface {
    static final Logger log = Logger.getLogger(BaseWSPolicyObjectImpl.class);

    public boolean baseIsCompatibleElement(OMElement element, String expectedLocalName) throws SSOException {
        String localName = element.getLocalName();
        String wspNSURI = element.getNamespace().getNamespaceURI();
        if (wspNSURI == null || wspNSURI.trim().length() == 0) {
            wspNSURI = element.getDefaultNamespace().getNamespaceURI();
        }
        if (wspNSURI == null || wspNSURI.trim().length() == 0) {
            log.error((Object)("Could not determine namespace for <" + localName + ">"));
            throw new SSOException("Unknown wsp namespace");
        }
        if (!localName.equals(expectedLocalName)) {
            log.error((Object)("Unknown element <" + localName + "> when expecting <" + expectedLocalName + ">"));
            return false;
        }
        if (!wspNSURI.equals("http://schemas.xmlsoap.org/ws/2004/09/policy")) {
            log.error((Object)("Unknown wsp namespace \"" + wspNSURI + "\" in <" + expectedLocalName + "> found"));
            throw new SSOException("Unknown wsp namespace");
        }
        return true;
    }
}

