/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.security.utility.element.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.security.utility.WSSecUtility;
import org.eclipse.alf.security.sso.common.ws.model.security.utility.element.Expires;
import org.eclipse.alf.security.sso.common.ws.model.security.utility.element.impl.BaseWSSecUtilitlyObjectImpl;

public class ExpiresImpl
extends BaseWSSecUtilitlyObjectImpl
implements Expires {
    private static final Logger log = Logger.getLogger(ExpiresImpl.class);
    protected Date expires;
    protected boolean inMilliseconds;

    public ExpiresImpl() {
        this.reset();
    }

    public ExpiresImpl(Date expires) {
        this.reset();
        this.expires = expires;
    }

    public String getLocalName() {
        return "Expires";
    }

    public void reset() {
        super.reset();
        this.expires = null;
        this.inMilliseconds = false;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof ExpiresImpl) {
            ExpiresImpl otherExpiresImpl = (ExpiresImpl)other;
            this.expires = otherExpiresImpl.expires;
            this.inMilliseconds = otherExpiresImpl.inMilliseconds;
        }
    }

    public void setExpires(Date expires) {
        this.expires = expires;
        this.setDirty();
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setInMilliseconds(boolean inMilliseconds) {
        this.inMilliseconds = inMilliseconds;
        this.setDirty();
    }

    public boolean getInMilliseconds() {
        return this.inMilliseconds;
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        SimpleDateFormat zulu = this.inMilliseconds ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        zulu.setTimeZone(TimeZone.getTimeZone("UTC"));
        OMElement expiresEl = WSSecUtility.createOMElement(parent, this.getLocalName());
        expiresEl.setText(zulu.format(this.expires));
        this.addAnyAttributesToElement(expiresEl);
        this.addAnyElementsToElementAsChildren(expiresEl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + expiresEl.toString() + "]"));
        }
        return expiresEl;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        if (!this.isCompatibleElement(element)) {
            return null;
        }
        ExpiresImpl expires = new ExpiresImpl();
        String expiresText = element.getText();
        if (expiresText != null && expiresText.trim().length() > 0) {
            SimpleDateFormat zulu = null;
            zulu = expiresText.indexOf(46) > 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            zulu.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                expires.setExpires(zulu.parse(expiresText));
            }
            catch (ParseException e) {
                log.error((Object)("Error while parsing <wst:Created> data:[" + expiresText + "]"), (Throwable)e);
                throw new SSOException("Error parsing timestamp");
            }
        } else {
            log.debug((Object)"<wsu:Expires>: empty date encoutntered while parsing");
        }
        expires.setParseSource(element);
        this.copyFrom(expires);
        return this;
    }
}

