/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust.element.impl;

import java.util.Iterator;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.GenericAttribute;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustVersion;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.Lifetime;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityTokenResponse;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedAttachedReference;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedSecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedTokenCancelled;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedUnattachedReference;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.TokenType;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.BaseWSTrustObjectImpl;

public class RequestSecurityTokenResponseImpl
extends BaseWSTrustObjectImpl
implements RequestSecurityTokenResponse {
    private static final Logger log = Logger.getLogger(RequestSecurityTokenResponseImpl.class);
    protected WSTrust wst;
    protected String contextAttribute;
    protected RequestedAttachedReference requestedAttachedReference;
    protected RequestedUnattachedReference requestedUnattachedReference;
    protected Lifetime lifetime;
    protected TokenType tokenType;
    protected RequestedSecurityToken requestedSecurityToken;
    protected RequestedTokenCancelled requestedTokenCancelled;

    public RequestSecurityTokenResponseImpl() {
        this.reset();
        this.wst = new WSTrust();
    }

    public RequestSecurityTokenResponseImpl(WSTrust wst) {
        this.reset();
        this.wst = wst;
    }

    public String getLocalName() {
        return "RequestSecurityTokenResponse";
    }

    public void reset() {
        super.reset();
        this.contextAttribute = null;
        this.requestedAttachedReference = null;
        this.requestedUnattachedReference = null;
        this.lifetime = null;
        this.tokenType = null;
        this.requestedSecurityToken = null;
        this.requestedTokenCancelled = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof RequestSecurityTokenResponseImpl) {
            RequestSecurityTokenResponseImpl otherRequestSecurityTokenResponseImpl = (RequestSecurityTokenResponseImpl)other;
            this.wst = otherRequestSecurityTokenResponseImpl.wst;
            this.contextAttribute = otherRequestSecurityTokenResponseImpl.contextAttribute;
            this.requestedAttachedReference = otherRequestSecurityTokenResponseImpl.requestedAttachedReference;
            this.requestedUnattachedReference = otherRequestSecurityTokenResponseImpl.requestedUnattachedReference;
            this.lifetime = otherRequestSecurityTokenResponseImpl.lifetime;
            this.tokenType = otherRequestSecurityTokenResponseImpl.tokenType;
            this.requestedSecurityToken = otherRequestSecurityTokenResponseImpl.requestedSecurityToken;
            this.requestedTokenCancelled = otherRequestSecurityTokenResponseImpl.requestedTokenCancelled;
        }
    }

    public String getContextAttribute() {
        return this.contextAttribute;
    }

    public void setContextAttribute(String contextAttribute) {
        this.contextAttribute = contextAttribute;
        this.setDirty();
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
        this.setDirty();
    }

    public RequestedSecurityToken getRequestedSecurityToken() {
        return this.requestedSecurityToken;
    }

    public void setRequestedSecurityToken(RequestedSecurityToken requestedSecurityToken) {
        this.requestedSecurityToken = requestedSecurityToken;
        this.setDirty();
    }

    public RequestedAttachedReference getRequestedAttachedReference() {
        return this.requestedAttachedReference;
    }

    public void setRequestedAttachedReference(RequestedAttachedReference requestedAttachedReference) {
        this.requestedAttachedReference = requestedAttachedReference;
        this.setDirty();
    }

    public RequestedUnattachedReference getRequestedUnattachedReference() {
        return this.requestedUnattachedReference;
    }

    public void setRequestedUnattachedReference(RequestedUnattachedReference requestedUnattachedReference) {
        this.requestedUnattachedReference = requestedUnattachedReference;
        this.setDirty();
    }

    public Lifetime getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(Lifetime lifetime) {
        this.lifetime = lifetime;
        this.setDirty();
    }

    public RequestedTokenCancelled getRequestedTokenCancelled() {
        return this.requestedTokenCancelled;
    }

    public void setRequestedTokenCancelled(RequestedTokenCancelled requestedTokenCancelled) {
        this.requestedTokenCancelled = requestedTokenCancelled;
        this.setDirty();
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        log.debug((Object)"RequestSecurityTokenResponseImpl.toOM()");
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement rstrEl = this.wst.createOMElement(parent, this.getLocalName());
        OMAttribute attrContext = null;
        if (this.contextAttribute != null) {
            attrContext = OMAbstractFactory.getOMFactory().createOMAttribute("Context", this.wst.getOMNamespace(), this.contextAttribute);
            rstrEl.addAttribute(attrContext);
        }
        if (this.tokenType != null) {
            this.tokenType.toOM(rstrEl);
        }
        if (this.requestedSecurityToken != null) {
            this.requestedSecurityToken.toOM(rstrEl);
        }
        if (this.lifetime != null) {
            this.lifetime.toOM(rstrEl);
        }
        if (this.requestedAttachedReference != null) {
            this.requestedAttachedReference.toOM(rstrEl);
        }
        if (this.requestedUnattachedReference != null) {
            this.requestedUnattachedReference.toOM(rstrEl);
        }
        if (this.requestedTokenCancelled != null) {
            this.requestedTokenCancelled.toOM(rstrEl);
        }
        this.addAnyAttributesToElement(rstrEl);
        this.addAnyElementsToElementAsChildren(rstrEl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created RSTR response:" + rstrEl.toString()));
        }
        return rstrEl;
    }

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        return this.baseIsCompatibleElementTrust(element, this.getLocalName()) != null;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        WSTrust wst = this.baseIsCompatibleElementTrust(element, this.getLocalName());
        if (wst == null) {
            return null;
        }
        RequestSecurityTokenResponseImpl rstr = new RequestSecurityTokenResponseImpl(wst);
        Iterator it = element.getAllAttributes();
        while (it.hasNext()) {
            OMAttribute attr = (OMAttribute)it.next();
            if (attr.getLocalName().equals("Context") && attr.getNamespace().getNamespaceURI().equals(wst.getNamespace())) {
                this.contextAttribute = attr.getAttributeValue();
            }
            rstr._anyAttr.add(new GenericAttribute(attr.getLocalName(), attr.getAttributeValue()));
        }
        if (wst.getVersion() == WSTrustVersion.V2) {
            if (!element.getFirstElement().getLocalName().equals("RequestSecurityTokenResponseCollection")) {
                log.error((Object)("Unrecognized element found: <" + element.getFirstElement().getLocalName() + "> when " + "expecting <" + "RequestSecurityTokenResponseCollection" + ">"));
                return null;
            }
            it = element.getFirstElement().getChildElements();
        } else {
            it = element.getChildElements();
        }
        if (it != null) {
            while (it.hasNext()) {
                OMElement workEl = (OMElement)it.next();
                String localName = workEl.getLocalName();
                if ("RequestedSecurityToken".equals(localName)) {
                    rstr.requestedSecurityToken = WSTrustObjectBuilder.buildRequestedSecurityToken(workEl);
                    continue;
                }
                if ("TokenType".equals(localName)) {
                    rstr.tokenType = WSTrustObjectBuilder.buildTokenType(workEl);
                    continue;
                }
                if ("RequestedAttachedReference".equals(localName)) {
                    rstr.requestedAttachedReference = WSTrustObjectBuilder.buildRequestedAttachedReference(workEl);
                    continue;
                }
                if ("RequestedUnattachedReference".equals(localName)) {
                    rstr.requestedUnattachedReference = WSTrustObjectBuilder.buildRequestedUnattachedReference(workEl);
                    continue;
                }
                if ("Lifetime".equals(localName)) {
                    rstr.lifetime = WSTrustObjectBuilder.buildLifetime(workEl);
                    continue;
                }
                if ("RequestedTokenCancelled".equals(localName)) {
                    rstr.requestedTokenCancelled = WSTrustObjectBuilder.buildRequestedTokenCancelled(workEl);
                    continue;
                }
                rstr._anyElement.add(workEl.cloneOMElement());
            }
        }
        rstr.setParseSource(element);
        this.copyFrom(rstr);
        return this;
    }

    public String getTokenId() {
        if (this.requestedAttachedReference != null && this.requestedAttachedReference.getSecrutityTokenReference() != null) {
            return this.requestedAttachedReference.getSecrutityTokenReference().getId();
        }
        if (this.requestedUnattachedReference != null && this.requestedUnattachedReference.getSecrutityTokenReference() != null) {
            return this.requestedUnattachedReference.getSecrutityTokenReference().getId();
        }
        if (this.requestedSecurityToken != null && this.requestedSecurityToken.getSecurityToken() != null) {
            return this.requestedSecurityToken.getSecurityToken().getId();
        }
        return null;
    }

    public WSTrust getWSTrust() {
        return this.wst;
    }
}

